/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service;

import flex.messaging.messages.Message;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.Destination;
import org.granite.context.GraniteContext;
import org.granite.messaging.amf.io.convert.Converter;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.service.MethodMatcher;
import org.granite.messaging.service.ServiceInvocationContext;
import org.granite.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMethodMatcher
implements MethodMatcher {
    @Override
    public ServiceInvocationContext findServiceMethod(Message message, Destination destination, Object service, String methodName, Object[] params) throws NoSuchMethodException {
        GraniteConfig config = GraniteContext.getCurrentInstance().getGraniteConfig();
        Converters converters = config.getConverters();
        Class<?> serviceClass = service.getClass();
        Type serviceClassGenericType = this.getGenericType(serviceClass);
        Converter[] convertersArray = null;
        Method serviceMethod = null;
        if (params == null || params.length == 0) {
            serviceMethod = serviceClass.getMethod(methodName, null);
        } else {
            for (Method method : serviceClass.getMethods()) {
                Type[] paramTypes;
                if (!methodName.equals(method.getName()) || (paramTypes = method.getGenericParameterTypes()).length != params.length) continue;
                if (serviceClassGenericType != null) {
                    this.findAndChange(paramTypes, serviceClassGenericType);
                }
                if ((convertersArray = this.getConvertersArray(converters, params, paramTypes)) == null) continue;
                serviceMethod = method;
                break;
            }
        }
        if (serviceMethod == null) {
            throw new NoSuchMethodException(serviceClass.getName() + '.' + methodName + StringUtil.toString(params));
        }
        params = this.convert(convertersArray, params, serviceMethod.getGenericParameterTypes());
        return new ServiceInvocationContext(message, destination, service, serviceMethod, params);
    }

    protected Converter[] getConvertersArray(Converters converters, Object[] values, Type[] targetTypes) {
        Converter[] convertersArray = new Converter[values.length];
        for (int i = 0; i < values.length; ++i) {
            convertersArray[i] = converters.getConverter(values[i], targetTypes[i]);
            if (convertersArray[i] != null) continue;
            return null;
        }
        return convertersArray;
    }

    protected Object[] convert(Converter[] convertersArray, Object[] values, Type[] targetTypes) {
        if (values.length > 0) {
            for (int i = 0; i < convertersArray.length; ++i) {
                values[i] = convertersArray[i].convert(values[i], targetTypes[i]);
            }
        }
        return values;
    }

    protected boolean findAndChange(Type[] paramTypes, Type superType) {
        int idx = -1;
        boolean find = false;
        for (int j = 0; j < paramTypes.length; ++j) {
            Type type = paramTypes[j];
            if (!(type instanceof TypeVariable)) continue;
            if (!find) {
                idx = j;
                find = true;
                continue;
            }
            throw new RuntimeException("There's two variable types.");
        }
        if (find) {
            paramTypes[idx] = superType;
        }
        return find;
    }

    protected Type getGenericType(Class<?> clazz) {
        try {
            ParameterizedType genericSuperclass = (ParameterizedType)clazz.getGenericSuperclass();
            Type[] actualTypeArguments = genericSuperclass.getActualTypeArguments();
            if (actualTypeArguments != null && actualTypeArguments.length == 1) {
                return actualTypeArguments[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

