/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import org.granite.messaging.service.ServiceException;
import org.granite.util.ClassUtil;
import org.granite.util.XMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbServiceMetadata
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private boolean stateful = false;
    private final Map<Method, Boolean> removeMethods = new HashMap<Method, Boolean>();
    private Class<?> invokeeClass = null;

    public EjbServiceMetadata() {
    }

    public EjbServiceMetadata(Class<?> scannedClass, Class<?> invokeeClass) {
        this.invokeeClass = invokeeClass;
        this.stateful = scannedClass.isAnnotationPresent(Stateful.class);
        if (this.stateful) {
            for (Method method : scannedClass.getMethods()) {
                Remove remove = method.getAnnotation(Remove.class);
                if (remove == null) continue;
                try {
                    method = invokeeClass.getMethod(method.getName(), method.getParameterTypes());
                    this.removeMethods.put(method, remove.retainIfException());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public EjbServiceMetadata(XMap properties, Class<?> invokeeClass) {
        this.invokeeClass = invokeeClass;
        this.stateful = properties.containsKey("ejb-stateful");
        if (this.stateful) {
            for (XMap removeMethod : properties.getAll("ejb-stateful/remove-method")) {
                String signature = removeMethod.get("signature");
                if (signature == null) {
                    throw new ServiceException("Missing signature in remove-method declaration: " + properties);
                }
                Boolean retainIfException = Boolean.valueOf(removeMethod.get("retain-if-exception"));
                try {
                    this.removeMethods.put(ClassUtil.getMethod(invokeeClass, signature), retainIfException);
                }
                catch (NoSuchMethodException e) {
                    throw new ServiceException("Could not find method: " + invokeeClass.getName() + "." + signature);
                }
            }
        }
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public boolean isRemoveMethod(Method method) {
        return this.removeMethods.containsKey(method);
    }

    public boolean getRetainIfException(Method method) {
        return this.removeMethods.get(method);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.invokeeClass.getName());
        out.writeBoolean(this.stateful);
        out.writeInt(this.removeMethods.size());
        for (Map.Entry<Method, Boolean> entry : this.removeMethods.entrySet()) {
            out.writeUTF(ClassUtil.getMethodSignature(entry.getKey()));
            out.writeBoolean(entry.getValue());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.invokeeClass = ClassUtil.forName(in.readUTF());
        this.stateful = in.readBoolean();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String signature = in.readUTF();
            boolean retainIfException = in.readBoolean();
            try {
                this.removeMethods.put(ClassUtil.getMethod(this.invokeeClass, signature), retainIfException);
                continue;
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

