/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service;

import flex.messaging.messages.RemotingMessage;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.granite.config.flex.Destination;
import org.granite.config.flex.DestinationRemoveListener;
import org.granite.context.GraniteContext;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceFactory;
import org.granite.messaging.service.ServiceInvoker;
import org.granite.messaging.service.SimpleServiceInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleServiceFactory
extends ServiceFactory
implements DestinationRemoveListener {
    private static final long serialVersionUID = 1L;
    private Set<String> invalidKeys = new HashSet<String>();

    @Override
    public ServiceInvoker<?> getServiceInstance(RemotingMessage request) throws ServiceException {
        SimpleServiceInvoker service;
        String messageType = request.getClass().getName();
        String destinationId = request.getDestination();
        GraniteContext context = GraniteContext.getCurrentInstance();
        Destination destination = context.getServicesConfig().findDestinationById(messageType, destinationId);
        if (destination == null) {
            throw new ServiceException("No matching destination: " + destinationId);
        }
        destination.addRemoveListener(this);
        Map<String, Object> cache = this.getCache(destination);
        String key = SimpleServiceInvoker.class.getName() + '.' + destination.getId();
        if (this.invalidKeys.contains(key)) {
            cache.remove(key);
            this.invalidKeys.remove(key);
        }
        if ((service = (SimpleServiceInvoker)cache.get(key)) == null) {
            service = new SimpleServiceInvoker(destination, this);
            cache.put(key, service);
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destinationRemoved(Destination destination) throws ServiceException {
        Set<String> set = this.invalidKeys;
        synchronized (set) {
            this.invalidKeys.add(SimpleServiceInvoker.class.getName() + '.' + destination.getId());
        }
    }

    private Map<String, Object> getCache(Destination destination) throws ServiceException {
        GraniteContext context = GraniteContext.getCurrentInstance();
        String scope = destination.getProperties().get("scope");
        Map<String, Object> cache = null;
        if (scope == null || "request".equals(scope)) {
            cache = context.getRequestMap();
        } else if ("session".equals(scope)) {
            cache = context.getSessionMap();
        } else if ("application".equals(scope)) {
            cache = Collections.synchronizedMap(context.getApplicationMap());
        } else {
            throw new ServiceException("Illegal scope in destination: " + destination);
        }
        return cache;
    }
}

