/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service.security;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Engine;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Service;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.granite.context.GraniteContext;
import org.granite.messaging.service.security.AbstractSecurityContext;
import org.granite.messaging.service.security.AbstractSecurityService;
import org.granite.messaging.service.security.SecurityServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassFishV3SecurityService
extends AbstractSecurityService {
    private final Field requestField;
    private Engine engine = null;

    public GlassFishV3SecurityService() {
        try {
            this.requestField = RequestFacade.class.getDeclaredField("request");
            this.requestField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get 'request' field in GlassFish V3 RequestFacade", e);
        }
    }

    protected Field getRequestField() {
        return this.requestField;
    }

    protected Engine getEngine() {
        return this.engine;
    }

    @Override
    public void configure(Map<String, String> params) {
        String serviceId = params.get("service");
        Server server = ServerFactory.getServer();
        if (server == null) {
            throw new NullPointerException("Could not get GlassFish V3 server");
        }
        Service service = null;
        if (serviceId != null) {
            service = server.findService(serviceId);
        } else {
            Service[] services = server.findServices();
            if (services != null && services.length > 0) {
                service = services[0];
            }
        }
        if (service == null) {
            throw new NullPointerException("Could not find GlassFish V3 service for: " + (serviceId != null ? serviceId : "(default)"));
        }
        this.engine = (Engine)service.getContainer();
        if (this.engine == null) {
            throw new NullPointerException("Could not find GlassFish V3 container for: " + (serviceId != null ? serviceId : "(default)"));
        }
    }

    @Override
    public void login(Object credentials) throws SecurityServiceException {
        String[] decoded = this.decodeBase64Credentials(credentials);
        HttpGraniteContext context = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = context.getRequest();
        Request request = this.getRequest(httpRequest);
        Realm realm = request.getContext().getRealm();
        Principal principal = realm.authenticate(decoded[0], decoded[1]);
        if (principal == null) {
            throw SecurityServiceException.newInvalidCredentialsException("Wrong username or password");
        }
        request.setAuthType("granite-security");
        request.setUserPrincipal(principal);
        Session session = request.getSessionInternal();
        session.setAuthType("granite-security");
        session.setPrincipal(principal);
        session.setNote("org.apache.catalina.session.USERNAME", (Object)decoded[0]);
        session.setNote("org.apache.catalina.session.PASSWORD", (Object)decoded[1]);
    }

    @Override
    public Object authorize(AbstractSecurityContext context) throws Exception {
        this.startAuthorization(context);
        HttpGraniteContext graniteContext = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = graniteContext.getRequest();
        Request request = this.getRequest(httpRequest);
        Session session = request.getSessionInternal();
        request.setAuthType(session.getAuthType());
        request.setUserPrincipal(session.getPrincipal());
        if (context.getDestination().isSecured()) {
            Principal principal = this.getPrincipal(httpRequest);
            if (principal == null) {
                HttpSession httpSession;
                if (httpRequest.getRequestedSessionId() != null && ((httpSession = httpRequest.getSession(false)) == null || httpRequest.getRequestedSessionId().equals(httpSession.getId()))) {
                    throw SecurityServiceException.newSessionExpiredException("Session expired");
                }
                throw SecurityServiceException.newNotLoggedInException("User not logged in");
            }
            boolean accessDenied = true;
            for (String role : context.getDestination().getRoles()) {
                if (!httpRequest.isUserInRole(role)) continue;
                accessDenied = false;
                break;
            }
            if (accessDenied) {
                throw SecurityServiceException.newAccessDeniedException("User not in required role");
            }
        }
        try {
            return this.endAuthorization(context);
        }
        catch (InvocationTargetException e) {
            for (Throwable t = e; t != null; t = ((Throwable)t).getCause()) {
                if (!(t instanceof SecurityException) && !"javax.ejb.EJBAccessException".equals(t.getClass().getName())) continue;
                throw SecurityServiceException.newAccessDeniedException(t.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void logout() throws SecurityServiceException {
        HttpGraniteContext context = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        Session session = this.getSession(context.getRequest(), false);
        if (session != null && session.getPrincipal() != null) {
            session.setAuthType(null);
            session.setPrincipal(null);
            session.removeNote("org.apache.catalina.session.USERNAME");
            session.removeNote("org.apache.catalina.session.PASSWORD");
            session.expire();
        }
    }

    protected Principal getPrincipal(HttpServletRequest httpRequest) {
        Request request = this.getRequest(httpRequest);
        Session session = request.getSessionInternal(false);
        return session != null ? session.getPrincipal() : null;
    }

    protected Session getSession(HttpServletRequest httpRequest, boolean create) {
        Request request = this.getRequest(httpRequest);
        return request.getSessionInternal(create);
    }

    protected Request getRequest(HttpServletRequest request) {
        while (request instanceof HttpServletRequestWrapper) {
            request = (HttpServletRequest)((HttpServletRequestWrapper)request).getRequest();
        }
        try {
            return (Request)this.requestField.get(request);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get GlassFish V3 request", e);
        }
    }

    protected Realm getRealm(HttpServletRequest request) {
        Request creq = this.getRequest(request);
        return creq.getContext().getRealm();
    }
}

