/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.webapp;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.ServicesConfig;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.AMF0Message;
import org.granite.messaging.amf.io.AMF0Deserializer;
import org.granite.messaging.amf.io.AMF0Serializer;
import org.granite.messaging.amf.process.AMF0MessageProcessor;
import org.granite.messaging.webapp.HttpGraniteContext;

public class AMFEndpoint {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(AMFEndpoint.class);

    public static void service(GraniteConfig graniteConfig, ServicesConfig servicesConfig, ServletContext context, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug(">> Incoming AMF0 request from: %s", request.getRequestURL());
        BufferedInputStream is = null;
        ServletOutputStream os = null;
        try {
            is = new BufferedInputStream((InputStream)request.getInputStream());
            HttpGraniteContext.createThreadIntance(graniteConfig, servicesConfig, context, request, response);
            log.debug(">> Deserializing AMF0 request...", new Object[0]);
            AMF0Deserializer deserializer = new AMF0Deserializer(is);
            AMF0Message amf0Request = deserializer.getAMFMessage();
            log.debug(">> Processing AMF0 request: %s", amf0Request);
            AMF0Message amf0Response = AMF0MessageProcessor.process(amf0Request);
            log.debug("<< Serializing AMF0 response: %s", amf0Response);
            response.setStatus(200);
            response.setContentType("application/x-amf");
            response.setDateHeader("Expire", 0L);
            response.setHeader("Cache-Control", "no-store");
            os = response.getOutputStream();
            AMF0Serializer serializer = new AMF0Serializer((OutputStream)os);
            serializer.serializeMessage(amf0Response);
            response.flushBuffer();
        }
        catch (IOException e) {
            if ("org.apache.catalina.connector.ClientAbortException".equals(e.getClass().getName())) {
                log.debug(e, "Connection closed by client", new Object[0]);
            } else {
                log.error(e, "AMF message error", new Object[0]);
            }
            throw e;
        }
        catch (Exception e) {
            log.error(e, "AMF message error", new Object[0]);
            throw new ServletException((Throwable)e);
        }
        finally {
            GraniteContext.release();
        }
    }
}

