/*
 * Decompiled with CFR 0.152.
 */
package org.granite.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.granite.config.api.Configuration;
import org.granite.config.api.internal.ConfigurationImpl;
import org.granite.logging.Logger;
import org.granite.osgi.adaptor.AMFServiceAdaptor;
import org.granite.osgi.metadata.ManifestMetadataParser;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static final Logger log = Logger.getLogger(Activator.class);
    private static final String DEFAULT_CONTEXT_PATH = "/WebContent";
    static ServiceTracker configurationTracker;
    String contextPath;
    ServiceRegistration configRegistration;
    ServiceTracker httpServiceTracker;
    ManifestMetadataParser metaParser;

    public void start(BundleContext context) throws Exception {
        this.contextPath = (String)context.getBundle().getHeaders().get("GraniteDS-Context");
        String string = this.contextPath = this.contextPath == null ? DEFAULT_CONTEXT_PATH : this.contextPath;
        if (!this.contextPath.startsWith("/")) {
            this.contextPath = "/" + this.contextPath;
        }
        ConfigurationImpl cfg = new ConfigurationImpl();
        this.configRegistration = context.registerService(Configuration.class.getName(), (Object)cfg, null);
        configurationTracker = new ServiceTracker(context, Configuration.class.getName(), null);
        configurationTracker.open();
        this.setupDefaultConfigurations(cfg);
        this.httpServiceTracker = new HttpServiceTracker(context);
        this.httpServiceTracker.open();
        this.metaParser = new ManifestMetadataParser(context);
        this.metaParser.start();
    }

    private void setupDefaultConfigurations(Configuration cfg) {
        cfg.setFlexServicesConfig("META-INF/flex/services-config.xml");
        cfg.setGraniteConfig("META-INF/granite/granite-config.xml");
    }

    public static Configuration getConfigurationService() {
        return (Configuration)configurationTracker.getService();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.configRegistration != null) {
            this.configRegistration.unregister();
            this.configRegistration = null;
        }
        if (configurationTracker != null) {
            configurationTracker.close();
            configurationTracker = null;
        }
        if (this.httpServiceTracker != null) {
            this.httpServiceTracker.close();
            this.httpServiceTracker = null;
        }
        if (this.metaParser != null) {
            this.metaParser.stop();
            this.metaParser = null;
        }
    }

    private class HttpServiceTracker
    extends ServiceTracker {
        String amfServicServleteAlias;

        public HttpServiceTracker(BundleContext context) {
            super(context, HttpService.class.getName(), null);
            this.amfServicServleteAlias = Activator.this.contextPath + "/graniteamf/amf";
        }

        public Object addingService(ServiceReference reference) {
            HttpService httpService = (HttpService)this.context.getService(reference);
            try {
                Hashtable<String, String> initparams = new Hashtable<String, String>();
                ((Dictionary)initparams).put("servlet-name", "AMFServiceServlet");
                httpService.registerServlet(this.amfServicServleteAlias, (Servlet)new AMFServiceAdaptor(this.context), initparams, httpService.createDefaultHttpContext());
            }
            catch (Exception e) {
                log.error(e, "Could not add service", new Object[0]);
            }
            return httpService;
        }

        public void removedService(ServiceReference reference, Object service) {
            HttpService httpService = (HttpService)service;
            httpService.unregister(this.amfServicServleteAlias);
            super.removedService(reference, service);
        }
    }
}

