/*
 * Decompiled with CFR 0.152.
 */
package org.granite.osgi.classloader;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.granite.logging.Logger;
import org.granite.messaging.service.annotations.RemoteDestination;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceClassLoader {
    private static final Logger log = Logger.getLogger(ServiceClassLoader.class);
    private static final String CLASS_SUFFIX = ".class";
    private Set<String> classesSet = new HashSet<String>();
    private Bundle bundle;

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    private static String packageForPath(String className) {
        return className.replace('.', '/');
    }

    private static String pathForPackage(String path) {
        return path.replace('/', '.').replace('\\', '.');
    }

    private void resolvePackage(String packageNamePath, boolean recursive) {
        Enumeration en = this.bundle.getEntryPaths(packageNamePath);
        if (en != null) {
            while (en.hasMoreElements()) {
                String entryPath = (String)en.nextElement();
                if (recursive && entryPath.endsWith("/")) {
                    this.resolvePackage(entryPath, recursive);
                    continue;
                }
                if (!entryPath.endsWith(CLASS_SUFFIX)) continue;
                String className = entryPath.substring(0, entryPath.length() - CLASS_SUFFIX.length());
                this.classesSet.add(ServiceClassLoader.pathForPackage(className));
            }
        }
    }

    public Class<?> loadClass(String className) {
        try {
            Class clazz = this.bundle.loadClass(className);
            if (clazz.isAnnotationPresent(RemoteDestination.class)) {
                if (log.isInfoEnabled()) {
                    log.info(clazz.toString() + " is a valid GDS Service", new Object[0]);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Set<Class<?>> loadClasses(String[] packages) {
        HashSet classes = new HashSet();
        if (packages != null) {
            for (int i = 0; i < packages.length; ++i) {
                String packageName = packages[i];
                if (this.bundle != null) {
                    boolean recursive = packageName.endsWith("*");
                    if (recursive) {
                        packageName = packageName.substring(0, packageName.length() - 2);
                    }
                    this.resolvePackage(ServiceClassLoader.packageForPath(packageName), recursive);
                    Iterator<String> it = this.classesSet.iterator();
                    while (it.hasNext()) {
                        Class clazz = null;
                        try {
                            clazz = this.bundle.loadClass(it.next());
                            if (clazz == null || !clazz.isAnnotationPresent(RemoteDestination.class)) continue;
                            if (log.isInfoEnabled()) {
                                log.info(clazz.toString() + " is a valid GDS Service", new Object[0]);
                            }
                            classes.add(clazz);
                        }
                        catch (ClassNotFoundException e) {
                            log.error("Service class not found", e);
                        }
                    }
                    continue;
                }
                if (!log.isInfoEnabled()) continue;
                log.info("Bundle is not specified, cannot load classes!!", new Object[0]);
            }
        }
        return classes;
    }
}

