/*
 * Decompiled with CFR 0.152.
 */
package org.granite.scan;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.granite.scan.FileScannedItem;
import org.granite.scan.ScannedItemHandler;
import org.granite.scan.Scanner;
import org.granite.scan.ZipScannedItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLScanner
implements Scanner {
    private final List<ScannedItemHandler> handlers = new ArrayList<ScannedItemHandler>();
    private final String marker;
    private final ClassLoader loader;

    public URLScanner(ScannedItemHandler handler) {
        this(handler, null, Thread.currentThread().getContextClassLoader());
    }

    public URLScanner(ScannedItemHandler handler, String marker) {
        this(handler, marker, Thread.currentThread().getContextClassLoader());
    }

    public URLScanner(ScannedItemHandler handler, ClassLoader loader) {
        this(handler, null, loader);
    }

    public URLScanner(ScannedItemHandler handler, String marker, ClassLoader loader) {
        this.marker = marker;
        this.handlers.add(handler);
        this.loader = loader;
    }

    public String getMarker() {
        return this.marker;
    }

    public void addHandler(ScannedItemHandler handler) {
        if (!this.handlers.contains(handler)) {
            this.handlers.add(handler);
        }
    }

    @Override
    public void addHandlers(Collection<ScannedItemHandler> handlers) {
        for (ScannedItemHandler handler : handlers) {
            this.addHandler(handler);
        }
    }

    @Override
    public ClassLoader getLoader() {
        return this.loader;
    }

    @Override
    public void scan() throws IOException {
        HashSet<String> paths = new HashSet<String>();
        if (this.marker == null) {
            if (!(this.loader instanceof URLClassLoader)) {
                throw new RuntimeException("ClassLoader used with no marker should be a URLClassLoader: " + this.loader);
            }
            for (URL url : ((URLClassLoader)this.loader).getURLs()) {
                String urlPath = url.getFile();
                if (urlPath.endsWith("/")) {
                    urlPath = urlPath.substring(0, urlPath.length() - 1);
                }
                paths.add(urlPath);
            }
        } else {
            Enumeration<URL> urlEnum = this.loader.getResources(this.marker);
            while (urlEnum.hasMoreElements()) {
                String urlPath = URLDecoder.decode(urlEnum.nextElement().getFile(), "UTF-8");
                if (urlPath.startsWith("file:")) {
                    urlPath = urlPath.substring(5);
                }
                if (urlPath.indexOf(33) > 0) {
                    urlPath = urlPath.substring(0, urlPath.indexOf(33));
                } else {
                    File dirOrArchive = new File(urlPath);
                    String[] tokens = this.marker.split("\\Q/\\E", -1);
                    for (int i = 0; i < tokens.length; ++i) {
                        dirOrArchive = dirOrArchive.getParentFile();
                    }
                    urlPath = dirOrArchive.getPath();
                }
                paths.add(urlPath);
            }
        }
        for (String urlPath : paths) {
            File file = new File(urlPath);
            if (file.isDirectory()) {
                this.handleDirectory(file, file);
                continue;
            }
            this.handleArchive(file);
        }
    }

    public void handleArchive(File file) throws ZipException, IOException {
        ZipFile zip = new ZipFile(file);
        ZipScannedItem markerItem = null;
        if (this.marker != null) {
            ZipEntry markerEntry = zip.getEntry(this.marker);
            markerItem = new ZipScannedItem(this, null, zip, markerEntry);
            for (ScannedItemHandler handler : this.handlers) {
                handler.handleMarkerItem(markerItem);
            }
        }
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || markerItem != null && markerItem.getEntry().getName().equals(entry.getName())) continue;
            for (ScannedItemHandler handler : this.handlers) {
                handler.handleScannedItem(new ZipScannedItem(this, markerItem, zip, entry));
            }
        }
    }

    public void handleDirectory(File root, File path) {
        FileScannedItem markerItem = null;
        if (this.marker != null) {
            File markerFile = new File(root, this.marker);
            markerItem = new FileScannedItem(this, null, root, markerFile);
            for (ScannedItemHandler handler : this.handlers) {
                handler.handleMarkerItem(markerItem);
            }
        }
        this.handleDirectory(markerItem, root, path);
    }

    public void handleDirectory(FileScannedItem markerItem, File root, File path) {
        for (File child : path.listFiles()) {
            if (child.isDirectory()) {
                this.handleDirectory(markerItem, root, child);
                continue;
            }
            if (markerItem != null && markerItem.getFile().equals(child)) continue;
            for (ScannedItemHandler handler : this.handlers) {
                handler.handleScannedItem(new FileScannedItem(this, markerItem, root, child));
            }
        }
    }
}

