/*
 * Decompiled with CFR 0.152.
 */
package org.granite.scan;

import java.io.IOException;
import java.io.InputStream;
import org.granite.scan.AbstractScannedItem;
import org.granite.scan.Scanner;
import org.jboss.virtual.VirtualFile;

public class VFSFileScannedItem
extends AbstractScannedItem {
    private final VirtualFile root;
    private final VirtualFile file;
    private String relativePath = null;

    public VFSFileScannedItem(Scanner scanner, VFSFileScannedItem marker, VirtualFile root, VirtualFile file) {
        super(scanner, marker);
        this.root = root;
        this.file = file;
    }

    public long getSize() {
        try {
            return this.file.getSize();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get size fo file " + this.file, e);
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.file.openStream();
    }

    public String getName() {
        return this.file.getName();
    }

    public String getAbsolutePath() {
        return this.file.getPathName();
    }

    public String getRelativePath() {
        if (this.relativePath == null) {
            try {
                StringBuffer sb = new StringBuffer();
                for (VirtualFile f = this.file; f != null && !this.root.equals((Object)f); f = f.getParent()) {
                    if (sb.length() > 0) {
                        sb.insert(0, '/');
                    }
                    sb.insert(0, f.getName());
                }
                this.relativePath = sb.toString();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not get path for file " + this.file, e);
            }
        }
        return this.relativePath;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VFSFileScannedItem)) {
            return false;
        }
        return this.file.equals((Object)((VFSFileScannedItem)obj).file) && this.root.equals((Object)((VFSFileScannedItem)obj).root);
    }

    public int hashCode() {
        return this.root.hashCode() + 31 * this.file.hashCode();
    }
}

