/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.data;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.persistence.RollbackException;
import javax.persistence.TransactionRequiredException;
import org.granite.messaging.service.ExceptionConverter;
import org.granite.messaging.service.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceExceptionConverter
implements ExceptionConverter {
    public static final String ENTITY_EXISTS = "Persistence.EntityExists";
    public static final String ENTITY_NOT_FOUND = "Persistence.EntityNotFound";
    public static final String NON_UNIQUE_RESULT = "Persistence.NonUnique";
    public static final String NO_RESULT = "Persistence.NoResult";
    public static final String OPTIMISTIC_LOCK = "Persistence.OptimisticLock";
    public static final String TRANSACTION_REQUIRED = "Persistence.TransactionRequired";
    public static final String ROLLBACK = "Persistence.Rollback";
    public static final String OTHER = "Persistence.Error";

    @Override
    public boolean accepts(Throwable t) {
        return t.getClass().equals(EntityExistsException.class) || t.getClass().equals(EntityNotFoundException.class) || t.getClass().equals(NonUniqueResultException.class) || t.getClass().equals(NoResultException.class) || t.getClass().equals(OptimisticLockException.class) || t.getClass().equals(TransactionRequiredException.class) || t.getClass().equals(RollbackException.class) || PersistenceException.class.isAssignableFrom(t.getClass());
    }

    @Override
    public ServiceException convert(Throwable t, String detail, Map<String, Object> extendedData) {
        String error = null;
        HashMap<String, Object> ex = null;
        if (t.getClass().equals(EntityExistsException.class)) {
            error = ENTITY_EXISTS;
        } else if (t.getClass().equals(EntityNotFoundException.class)) {
            error = ENTITY_NOT_FOUND;
        } else if (t.getClass().equals(NonUniqueResultException.class)) {
            error = NON_UNIQUE_RESULT;
        } else if (t.getClass().equals(NoResultException.class)) {
            error = NO_RESULT;
        } else if (t.getClass().equals(OptimisticLockException.class)) {
            error = OPTIMISTIC_LOCK;
            ex = new HashMap<String, Object>();
            ex.put("entity", ((OptimisticLockException)t).getEntity());
        } else {
            error = t.getClass().equals(TransactionRequiredException.class) ? TRANSACTION_REQUIRED : (t.getClass().equals(RollbackException.class) ? ROLLBACK : OTHER);
        }
        ServiceException se = new ServiceException(error, t.getMessage(), detail, t);
        if (ex != null && !ex.isEmpty()) {
            se.getExtendedData().putAll((Map<String, Object>)ex);
        }
        return se;
    }
}

