/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.ejb;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import org.granite.logging.Logger;
import org.granite.scan.ScannedItem;
import org.granite.scan.ScannedItemHandler;
import org.granite.tide.util.Observer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbScannedItemHandler
implements ScannedItemHandler {
    private static final Logger log = Logger.getLogger(EjbScannedItemHandler.class);
    private static final EjbScannedItemHandler instance = new EjbScannedItemHandler();
    private final Map<String, Set<Method>> observers = new HashMap<String, Set<Method>>();

    public static EjbScannedItemHandler instance() {
        return instance;
    }

    static EjbScannedItemHandler instance(boolean reset) {
        EjbScannedItemHandler.instance.observers.clear();
        return instance;
    }

    private EjbScannedItemHandler() {
    }

    @Override
    public void handleMarkerItem(ScannedItem item) {
    }

    @Override
    public void handleScannedItem(ScannedItem item) {
        if ("class".equals(item.getExtension()) && item.getName().indexOf(36) == -1) {
            try {
                Class<?> clazz = item.loadAsClass();
                if (clazz.isAnnotationPresent(Stateless.class) || clazz.isAnnotationPresent(Stateful.class)) {
                    for (Method method : clazz.getMethods()) {
                        if (!method.isAnnotationPresent(Observer.class)) continue;
                        Observer o = method.getAnnotation(Observer.class);
                        Set<Method> methods = this.observers.get(o.value());
                        if (methods == null) {
                            methods = new HashSet<Method>();
                            this.observers.put(o.value(), methods);
                        }
                        methods.add(method);
                    }
                }
            }
            catch (Exception e) {
                log.debug(e, "Could not introspect scanned item: %s", item);
            }
        }
    }

    public Map<String, Set<Method>> getObservers() {
        return this.observers;
    }
}

