/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.granite.logging.Logger;
import org.granite.tide.invocation.ContextEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContext
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(AbstractContext.class);
    private static final ThreadLocal<AbstractContext> contexts = new ThreadLocal();
    private final Map<String, Set<Method>> observers;
    private final List<ContextEvent> remoteEvents;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractContext(Map<String, Set<Method>> observers) {
        ThreadLocal<AbstractContext> threadLocal = contexts;
        synchronized (threadLocal) {
            if (contexts.get() != null) {
                throw new IllegalStateException("Context already created");
            }
            this.observers = observers;
            this.remoteEvents = new ArrayList<ContextEvent>();
            contexts.set(this);
        }
    }

    public List<ContextEvent> getRemoteEvents() {
        return this.remoteEvents;
    }

    protected abstract Set<String> getRemoteObservers();

    protected abstract Object callMethod(Method var1, Object ... var2) throws Exception;

    public static AbstractContext instance() {
        return contexts.get();
    }

    public static void raiseEvent(String name, Object ... args) {
        Set<String> remoteObservers;
        AbstractContext instance = AbstractContext.instance();
        Map<String, Set<Method>> observers = instance.observers;
        if (observers.containsKey(name)) {
            for (Method method : observers.get(name)) {
                try {
                    instance.callMethod(method, args);
                }
                catch (Exception e) {
                    log.error(e, "Could not call method: %s", method);
                }
            }
        }
        if ((remoteObservers = instance.getRemoteObservers()).contains(name)) {
            instance.remoteEvents.add(new ContextEvent(name, args));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove() {
        AbstractContext context = contexts.get();
        if (context != null) {
            try {
                context.clear();
                context.remoteEvents.clear();
            }
            finally {
                contexts.remove();
            }
        }
    }
}

