/*
 * Decompiled with CFR 0.152.
 */
package org.granite.util;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.granite.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassUtil {
    public static Object newInstance(String type) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return ClassUtil.forName(type).newInstance();
    }

    public static <T> T newInstance(String type, Class<T> cast) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return ClassUtil.forName(type, cast).newInstance();
    }

    public static Object newInstance(String type, Class<?>[] argsClass, Object[] argsValues) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return ClassUtil.newInstance(ClassUtil.forName(type), argsClass, argsValues);
    }

    public static <T> T newInstance(Class<?> type, Class<T> cast) throws InstantiationException, IllegalAccessException {
        return (T)type.newInstance();
    }

    public static <T> T newInstance(Class<T> type, Class<?>[] argsClass, Object[] argsValues) throws InstantiationException, IllegalAccessException {
        T instance = null;
        try {
            Constructor<T> constructorDef = type.getConstructor(argsClass);
            instance = constructorDef.newInstance(argsValues);
        }
        catch (SecurityException e) {
            throw new InstantiationException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new InstantiationException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new InstantiationException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new InstantiationException(e.getMessage());
        }
        return instance;
    }

    public static Class<?> forName(String type) throws ClassNotFoundException {
        try {
            return ClassUtil.class.getClassLoader().loadClass(type);
        }
        catch (ClassNotFoundException e) {
            return Thread.currentThread().getContextClassLoader().loadClass(type);
        }
    }

    public static <T> Class<T> forName(String type, Class<T> cast) throws ClassNotFoundException {
        try {
            return ClassUtil.class.getClassLoader().loadClass(type);
        }
        catch (ClassNotFoundException e) {
            return Thread.currentThread().getContextClassLoader().loadClass(type);
        }
    }

    public static Constructor<?> getConstructor(String type, Class<?>[] paramTypes) throws ClassNotFoundException, NoSuchMethodException {
        return ClassUtil.getConstructor(ClassUtil.forName(type), paramTypes);
    }

    public static <T> Constructor<T> getConstructor(Class<T> type, Class<?>[] paramTypes) throws NoSuchMethodException {
        return type.getConstructor(paramTypes);
    }

    public static <T> List<T> emptyList(Class<T> type) {
        return Collections.emptyList();
    }

    public static <T> Set<T> emptySet(Class<T> type) {
        return Collections.emptySet();
    }

    public static <T, U> Map<T, U> emptyMap(Class<T> keyType, Class<U> valueType) {
        return Collections.emptyMap();
    }

    public static boolean isPrimitive(Type type) {
        return type instanceof Class && ((Class)type).isPrimitive();
    }

    public static Class<?> classOfType(Type type) {
        Type[] ubs;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof WildcardType && (ubs = ((WildcardType)type).getUpperBounds()).length > 0) {
            return ClassUtil.classOfType(ubs[0]);
        }
        if (type instanceof GenericArrayType) {
            Class<?> ct = ClassUtil.classOfType(((GenericArrayType)type).getGenericComponentType());
            return ct != null ? Array.newInstance(ct, 0).getClass() : Object[].class;
        }
        if (type instanceof TypeVariable && (ubs = ((TypeVariable)type).getBounds()).length > 0) {
            return ClassUtil.classOfType(ubs[0]);
        }
        return Object.class;
    }

    public static Type getBoundType(TypeVariable<?> typeVariable) {
        Type[] ubs = typeVariable.getBounds();
        if (ubs.length > 0) {
            return ubs[0];
        }
        if (typeVariable.getGenericDeclaration() instanceof Type) {
            return (Type)typeVariable.getGenericDeclaration();
        }
        return typeVariable;
    }

    public static String getPackageName(Class<?> clazz) {
        return clazz.getPackage() != null ? clazz.getPackage().getName() : "";
    }

    public static PropertyDescriptor[] getProperties(Class<?> clazz) {
        try {
            Field[] fields;
            PropertyDescriptor[] properties = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!Boolean.class.equals(field.getType())) continue;
                boolean found = false;
                for (PropertyDescriptor property : properties) {
                    if (!property.getName().equals(field.getName())) continue;
                    found = true;
                    if (property.getReadMethod() != null) break;
                    try {
                        Method readMethod = clazz.getDeclaredMethod(ClassUtil.getIsMethodName(field.getName()), new Class[0]);
                        if (!Modifier.isPublic(readMethod.getModifiers()) || Modifier.isStatic(readMethod.getModifiers())) break;
                        property.setReadMethod(readMethod);
                    }
                    catch (NoSuchMethodException e) {}
                    break;
                }
                if (found) continue;
                try {
                    Method readMethod = clazz.getDeclaredMethod(ClassUtil.getIsMethodName(field.getName()), new Class[0]);
                    if (!Modifier.isPublic(readMethod.getModifiers()) || Modifier.isStatic(readMethod.getModifiers())) continue;
                    PropertyDescriptor[] propertiesTmp = new PropertyDescriptor[properties.length + 1];
                    System.arraycopy(properties, 0, propertiesTmp, 0, properties.length);
                    propertiesTmp[properties.length] = new PropertyDescriptor(field.getName(), readMethod, null);
                    properties = propertiesTmp;
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            return properties;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not introspect properties of class: " + clazz, e);
        }
    }

    private static String getIsMethodName(String name) {
        return "is" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static ClassLoader getClassLoader(Class<?> clazz) {
        return clazz.getClassLoader() != null ? clazz.getClassLoader() : ClassLoader.getSystemClassLoader();
    }

    public static URL findResource(Class<?> clazz) {
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (clazz.isPrimitive()) {
            return null;
        }
        URL url = ClassUtil.getClassLoader(clazz).getResource(ClassUtil.toResourceName(clazz));
        String path = url.toString();
        if (path.indexOf(32) != -1) {
            try {
                url = new URL(path.replace(" ", "%20"));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    public static String toResourceName(Class<?> clazz) {
        return clazz.getName().replace('.', '/').concat(".class");
    }

    public static String getMethodSignature(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getName()).append('(');
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(ClassUtil.getTypeSignature(params[i]));
        }
        sb.append(')');
        return sb.toString();
    }

    public static String getTypeSignature(Class<?> type) {
        if (type.isArray()) {
            try {
                int dimensions = 1;
                Class<?> clazz = type.getComponentType();
                while (clazz.isArray()) {
                    ++dimensions;
                    clazz = clazz.getComponentType();
                }
                StringBuffer sb = new StringBuffer(clazz.getName());
                while (dimensions-- > 0) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.getName();
    }

    public static Method getMethod(Class<?> clazz, String signature) throws NoSuchMethodException {
        if (!(signature = StringUtil.removeSpaces(signature)).endsWith(")")) {
            signature = signature + "()";
        }
        for (Method method : clazz.getMethods()) {
            if (!signature.equals(ClassUtil.getMethodSignature(method))) continue;
            return method;
        }
        throw new NoSuchMethodException("Could not find method: " + signature + " in class: " + clazz);
    }
}

