/*
 * Decompiled with CFR 0.152.
 */
package org.granite.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOM {
    protected static final String TO_STRING_XSL = "<?xml version='1.0' encoding='UTF-8'?><xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>    <xsl:strip-space elements='*'/>    <xsl:template match='/'>        <xsl:copy-of select='*'/>    </xsl:template></xsl:stylesheet>";
    private final ErrorHandler errorHandler;
    private DocumentBuilderFactory documentBuilderFactory = null;
    private DocumentBuilderFactory validatingDocumentBuilderFactory = null;
    private XPathFactory xPathFactory = null;
    private Templates toStringTemplates = null;

    public DOM() {
        this(null);
    }

    public DOM(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected DocumentBuilderFactory getDocumentBuilderFactory() {
        if (this.documentBuilderFactory == null) {
            try {
                this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
                this.documentBuilderFactory.setCoalescing(true);
                this.documentBuilderFactory.setIgnoringComments(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.documentBuilderFactory;
    }

    protected DocumentBuilderFactory getValidatingDocumentBuilderFactory() {
        if (this.validatingDocumentBuilderFactory == null) {
            try {
                this.validatingDocumentBuilderFactory = DocumentBuilderFactory.newInstance();
                this.validatingDocumentBuilderFactory.setCoalescing(true);
                this.validatingDocumentBuilderFactory.setIgnoringComments(true);
                this.validatingDocumentBuilderFactory.setValidating(true);
                this.validatingDocumentBuilderFactory.setIgnoringElementContentWhitespace(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.validatingDocumentBuilderFactory;
    }

    protected XPathFactory getXPathFactory() {
        if (this.xPathFactory == null) {
            try {
                this.xPathFactory = XPathFactory.newInstance();
            }
            catch (Exception e) {
                try {
                    Class<?> factoryClass = Thread.currentThread().getContextClassLoader().loadClass("org.apache.xpath.jaxp.XPathFactoryImpl");
                    Method m = factoryClass.getMethod("newInstance", String.class, String.class, ClassLoader.class);
                    this.xPathFactory = (XPathFactory)m.invoke(null, "http://java.sun.com/jaxp/xpath/dom", "org.apache.xpath.jaxp.XPathFactoryImpl", null);
                }
                catch (Exception f) {
                    throw new RuntimeException("XPathFactory could not be found", f);
                }
            }
        }
        return this.xPathFactory;
    }

    protected Templates getToStringTemplates() {
        if (this.toStringTemplates == null) {
            try {
                this.toStringTemplates = TransformerFactory.newInstance().newTemplates(new StreamSource(new StringReader(TO_STRING_XSL)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.toStringTemplates;
    }

    public Document loadDocument(InputStream input) throws IOException, SAXException {
        try {
            return this.getDocumentBuilderFactory().newDocumentBuilder().parse(input);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public Document loadDocument(InputStream input, EntityResolver resolver) throws IOException, SAXException {
        try {
            DocumentBuilder builder = this.getValidatingDocumentBuilderFactory().newDocumentBuilder();
            builder.setEntityResolver(resolver);
            if (this.errorHandler != null) {
                builder.setErrorHandler(this.errorHandler);
            }
            return builder.parse(input);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void saveDocument(Document document, OutputStream output) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "no");
        transformer.transform(new DOMSource(document), new StreamResult(output));
    }

    public Document newDocument() {
        return this.newDocument(null);
    }

    public Document newDocument(String root) {
        try {
            Document document = this.getDocumentBuilderFactory().newDocumentBuilder().newDocument();
            document.setXmlVersion("1.0");
            document.setXmlStandalone(true);
            if (root != null) {
                this.newElement(document, root);
            }
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public Document getDocument(Node node) {
        return node instanceof Document ? (Document)node : node.getOwnerDocument();
    }

    public Element newElement(Node parent, String name) {
        return this.newElement(parent, name, null);
    }

    public Element newElement(Node parent, String name, String value) {
        Element element = this.getDocument(parent).createElement(name);
        parent.appendChild(element);
        if (value != null) {
            element.setTextContent(value);
        }
        return element;
    }

    public String getNormalizedValue(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 1) {
            StringBuilder sb = new StringBuilder();
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                String value;
                if (child.getNodeType() != 3 || child.getNodeValue() == null || (value = child.getNodeValue().trim()).length() <= 0) continue;
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(value);
            }
            return sb.toString();
        }
        return node.getNodeValue() != null ? node.getNodeValue().trim() : null;
    }

    public String setValue(Node node, String value) {
        if (node != null) {
            String previousValue = this.getNormalizedValue(node);
            switch (node.getNodeType()) {
                case 1: {
                    ((Element)node).setTextContent(value);
                    break;
                }
                case 2: 
                case 3: {
                    node.setNodeValue(value);
                    break;
                }
                default: {
                    throw new RuntimeException("Illegal node for write operations: " + node);
                }
            }
            return previousValue;
        }
        return null;
    }

    public Node selectSingleNode(Object context, String expression) throws XPathExpressionException {
        return (Node)this.getXPathFactory().newXPath().evaluate(expression, context, XPathConstants.NODE);
    }

    public List<Node> selectNodes(Object context, String expression) throws XPathExpressionException {
        NodeList nodeList = (NodeList)this.getXPathFactory().newXPath().evaluate(expression, context, XPathConstants.NODESET);
        ArrayList<Node> nodes = new ArrayList<Node>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            nodes.add(nodeList.item(i));
        }
        return nodes;
    }

    public String toString(Node node) {
        try {
            Transformer transformer = this.getToStringTemplates().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("encoding", Charset.defaultCharset().name());
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StringWriter sw = new StringWriter();
            transformer.transform(new DOMSource(node), new StreamResult(sw));
            return sw.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

