/*
 * Decompiled with CFR 0.152.
 */
package org.granite.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.Version;
import org.granite.util.Reflections;

public class Entity {
    private Class<?> entityClass;
    private Method identifierGetter;
    private Field identifierField;
    private Method versionGetter;
    private Field versionField;
    private Object wrappedEntity;
    private String name;

    public Entity(Object entity) {
        Class<?> clazz;
        if (entity instanceof Class) {
            this.entityClass = (Class)entity;
        } else {
            this.entityClass = entity.getClass();
            this.wrappedEntity = entity;
        }
        if (this.entityClass.isAnnotationPresent(javax.persistence.Entity.class)) {
            this.name = !"".equals(this.entityClass.getAnnotation(javax.persistence.Entity.class).name()) ? this.entityClass.getAnnotation(javax.persistence.Entity.class).name() : this.entityClass.getName();
        }
        for (clazz = this.entityClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.isAnnotationPresent(Id.class) || method.isAnnotationPresent(EmbeddedId.class)) {
                    this.identifierGetter = method;
                }
                if (!method.isAnnotationPresent(Version.class)) continue;
                this.versionGetter = method;
            }
        }
        if (this.identifierGetter == null) {
            for (clazz = this.entityClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
                for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                    if (accessibleObject.isAnnotationPresent(Id.class) || accessibleObject.isAnnotationPresent(EmbeddedId.class)) {
                        this.identifierField = accessibleObject;
                        if (!accessibleObject.isAccessible()) {
                            ((Field)accessibleObject).setAccessible(true);
                        }
                    }
                    if (!accessibleObject.isAnnotationPresent(Version.class)) continue;
                    this.versionField = accessibleObject;
                    if (accessibleObject.isAccessible()) continue;
                    ((Field)accessibleObject).setAccessible(true);
                }
            }
        }
    }

    public Object getIdentifier() {
        if (this.wrappedEntity == null) {
            throw new IllegalStateException("No entity instance defined");
        }
        if (this.identifierGetter != null) {
            return Reflections.invokeAndWrap(this.identifierGetter, this.wrappedEntity, new Object[0]);
        }
        if (this.identifierField != null) {
            return Reflections.getAndWrap(this.identifierField, this.wrappedEntity);
        }
        throw new IllegalStateException("@Id attribute not found for entity class: " + this.wrappedEntity.getClass().getName());
    }

    public Object getVersion() {
        if (this.versionGetter != null) {
            return Reflections.invokeAndWrap(this.versionGetter, this.wrappedEntity, new Object[0]);
        }
        if (this.versionField != null) {
            return Reflections.getAndWrap(this.versionField, this.wrappedEntity);
        }
        return null;
    }

    public Method getIdentifierGetter() {
        return this.identifierGetter;
    }

    public Field getIdentifierField() {
        return this.identifierField;
    }

    public Type getIdentifierType() {
        if (this.identifierGetter != null) {
            return this.identifierGetter.getGenericReturnType();
        }
        if (this.identifierField != null) {
            return this.identifierField.getGenericType();
        }
        throw new IllegalStateException("@Id attribute not found for entity class: " + this.entityClass.getName());
    }

    public Method getVersionGetter() {
        return this.versionGetter;
    }

    public Field getVersionField() {
        return this.versionField;
    }

    public boolean isVersioned() {
        return this.versionGetter != null || this.versionField != null;
    }

    public String getName() {
        return this.name;
    }
}

