/*
 * Decompiled with CFR 0.152.
 */
package org.granite.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.jar.JarEntry;

public class URIUtil {
    public static final String CLASSPATH_SCHEME = "class";

    public static InputStream getInputStream(URI uri, ClassLoader loader) throws IOException {
        InputStream is = null;
        String scheme = uri.getScheme();
        if (CLASSPATH_SCHEME.equals(scheme)) {
            if (loader != null) {
                is = loader.getResourceAsStream(uri.getSchemeSpecificPart());
            }
            if (is == null && (is = Thread.currentThread().getContextClassLoader().getResourceAsStream(uri.getSchemeSpecificPart())) == null) {
                throw new IOException("Resource not found exception: " + uri);
            }
        } else {
            is = scheme == null || scheme.length() <= 1 ? new FileInputStream(uri.toString()) : uri.toURL().openStream();
        }
        return is;
    }

    public static InputStream getInputStream(URI uri) throws IOException {
        return URIUtil.getInputStream(uri, null);
    }

    public static String getContentAsString(URI uri) throws IOException {
        return URIUtil.getContentAsString(uri, Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentAsString(URI uri, Charset charset) throws IOException {
        InputStream is = null;
        try {
            is = URIUtil.getInputStream(uri);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, charset));
            StringBuilder sb = new StringBuilder(1024);
            char[] chars = new char[256];
            int count = -1;
            while ((count = reader.read(chars)) != -1) {
                sb.append(chars, 0, count);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContentAsBytes(URI uri) throws IOException {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(URIUtil.getInputStream(uri));
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            int b = 0;
            while ((b = ((InputStream)is).read()) != -1) {
                baos.write(b);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    public static long lastModified(URI uri) throws IOException {
        if (uri == null) {
            return -1L;
        }
        String scheme = uri.getScheme();
        if (scheme == null || scheme.length() <= 1) {
            return new File(uri).lastModified();
        }
        return URIUtil.lastModified(uri.toURL());
    }

    public static long lastModified(URL url) throws IOException {
        long lastModified = -1L;
        if (url != null) {
            JarEntry entry;
            URLConnection connection = url.openConnection();
            if (connection instanceof JarURLConnection && (entry = ((JarURLConnection)connection).getJarEntry()) != null) {
                lastModified = entry.getTime();
            }
            if (lastModified == -1L) {
                lastModified = connection.getLastModified();
            }
        }
        return lastModified == 0L ? -1L : lastModified;
    }
}

