/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.gae;

import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import flex.messaging.messages.AsyncMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.granite.gravity.Channel;
import org.granite.gravity.Subscription;
import org.granite.gravity.gae.GAEServiceAdapter;
import org.granite.gravity.gae.GAETopicId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GAETopic {
    private final GAETopicId id;
    private final GAEServiceAdapter serviceAdapter;
    private static final String TOPIC_PREFIX = "org.granite.gravity.gae.topic.";
    private static MemcacheService gaeCache = MemcacheServiceFactory.getMemcacheService();
    private ConcurrentMap<String, GAETopic> children = new ConcurrentHashMap<String, GAETopic>();
    private GAETopic wild;
    private GAETopic wildWild;

    public GAETopic(String topicId, GAEServiceAdapter serviceAdapter) {
        this.id = new GAETopicId(topicId);
        this.serviceAdapter = serviceAdapter;
    }

    public String getId() {
        return this.id.toString();
    }

    public GAETopicId getTopicId() {
        return this.id;
    }

    public GAETopic getChild(GAETopicId topicId) {
        String next = topicId.getSegment(this.id.depth());
        if (next == null) {
            return null;
        }
        GAETopic topic = (GAETopic)this.children.get(next);
        if (topic == null || topic.getTopicId().depth() == topicId.depth()) {
            return topic;
        }
        return topic.getChild(topicId);
    }

    public void addChild(GAETopic topic) {
        GAETopicId child = topic.getTopicId();
        if (!this.id.isParentOf(child)) {
            throw new IllegalArgumentException(this.id + " not parent of " + child);
        }
        String next = child.getSegment(this.id.depth());
        if (child.depth() - this.id.depth() == 1) {
            GAETopic old = this.children.putIfAbsent(next, topic);
            if (old != null) {
                throw new IllegalArgumentException("Already Exists");
            }
            if ("*".equals(next)) {
                this.wild = topic;
            } else if ("**".equals(next)) {
                this.wildWild = topic;
            }
        } else {
            GAETopic branch = this.serviceAdapter.getTopic(String.valueOf(this.id.depth() == 0 ? "/" : String.valueOf(this.id.toString()) + "/") + next, true);
            branch.addChild(topic);
        }
    }

    private void removeExpiredSubscriptions(Map<String, Subscription> subscriptions) {
        ArrayList<String> channelIds = new ArrayList<String>(subscriptions.size());
        for (Subscription sub : subscriptions.values()) {
            channelIds.add("org.granite.gravity.gae.channel." + sub.getChannel().getId());
        }
        Map channels = gaeCache.getAll(channelIds);
        Iterator<Map.Entry<String, Subscription>> ime = subscriptions.entrySet().iterator();
        while (ime.hasNext()) {
            Map.Entry<String, Subscription> me = ime.next();
            if (channels.containsKey("org.granite.gravity.gae.channel." + me.getValue().getChannel().getId())) continue;
            ime.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Channel channel, String destination, String subscriptionId, String selector, boolean noLocal) {
        GAETopic gAETopic = this;
        synchronized (gAETopic) {
            Subscription subscription = channel.addSubscription(destination, this.getId(), subscriptionId, noLocal);
            subscription.setSelector(selector);
            HashMap<String, Subscription> subscriptions = (HashMap<String, Subscription>)gaeCache.get((Object)(TOPIC_PREFIX + this.getId()));
            if (subscriptions == null) {
                subscriptions = new HashMap<String, Subscription>();
            } else {
                this.removeExpiredSubscriptions((Map<String, Subscription>)subscriptions);
            }
            subscriptions.put(subscriptionId, subscription);
            gaeCache.put((Object)(TOPIC_PREFIX + this.getId()), subscriptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(Channel channel, String subscriptionId) {
        GAETopic gAETopic = this;
        synchronized (gAETopic) {
            Map subscriptions = (Map)gaeCache.get((Object)(TOPIC_PREFIX + this.getId()));
            if (subscriptions != null) {
                subscriptions.remove(subscriptionId);
                this.removeExpiredSubscriptions(subscriptions);
            }
            gaeCache.put((Object)(TOPIC_PREFIX + this.getId()), (Object)subscriptions);
            channel.removeSubscription(subscriptionId);
        }
    }

    public void publish(GAETopicId to, Channel fromChannel, AsyncMessage msg) {
        int tail = to.depth() - this.id.depth();
        switch (tail) {
            case 0: {
                Map subscriptions = (Map)gaeCache.get((Object)(TOPIC_PREFIX + this.getId()));
                if (subscriptions == null) break;
                for (Subscription subscription : subscriptions.values()) {
                    AsyncMessage m = msg.clone();
                    subscription.deliver(fromChannel, m);
                }
                break;
            }
            case 1: {
                AsyncMessage m;
                Map subs;
                if (this.wild != null) {
                    subs = (Map)gaeCache.get((Object)(TOPIC_PREFIX + this.wild.getId()));
                    for (Subscription subscription : subs.values()) {
                        m = msg.clone();
                        subscription.deliver(fromChannel, m);
                    }
                }
            }
            default: {
                String next;
                GAETopic topic;
                AsyncMessage m;
                Map subs;
                if (this.wildWild != null) {
                    subs = (Map)gaeCache.get((Object)(TOPIC_PREFIX + this.wildWild.getId()));
                    for (Subscription subscription : subs.values()) {
                        m = msg.clone();
                        subscription.deliver(fromChannel, m);
                    }
                }
                if ((topic = (GAETopic)this.children.get(next = to.getSegment(this.id.depth()))) == null) break;
                topic.publish(to, fromChannel, msg);
            }
        }
    }

    public String toString() {
        return String.valueOf(this.id.toString()) + " {" + this.children.values() + "}";
    }
}

