/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.ejb;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import org.granite.logging.Logger;
import org.granite.scan.ScannedItem;
import org.granite.scan.ScannedItemHandler;
import org.granite.tide.util.Observer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbScannedItemHandler
implements ScannedItemHandler {
    private static final Logger log = Logger.getLogger(EjbScannedItemHandler.class);
    private static final EjbScannedItemHandler instance = new EjbScannedItemHandler();
    private final Map<Class<?>, Class<?>> scannedClasses = new HashMap();
    private final Map<String, Set<Method>> observers = new HashMap<String, Set<Method>>();

    public static EjbScannedItemHandler instance() {
        return instance;
    }

    static EjbScannedItemHandler instance(boolean reset) {
        EjbScannedItemHandler.instance.scannedClasses.clear();
        EjbScannedItemHandler.instance.observers.clear();
        return instance;
    }

    private EjbScannedItemHandler() {
    }

    @Override
    public boolean handleMarkerItem(ScannedItem item) {
        return false;
    }

    @Override
    public void handleScannedItem(ScannedItem item) {
        if ("class".equals(item.getExtension()) && item.getName().indexOf(36) == -1) {
            try {
                Class<?> clazz = item.loadAsClass();
                if (clazz.isAnnotationPresent(Stateless.class) || clazz.isAnnotationPresent(Stateful.class)) {
                    Class i;
                    int n;
                    int n2;
                    GenericDeclaration[] genericDeclarationArray;
                    this.scannedClasses.put(clazz, clazz);
                    if (clazz.isAnnotationPresent(Local.class)) {
                        genericDeclarationArray = clazz.getAnnotation(Local.class).value();
                        n2 = genericDeclarationArray.length;
                        n = 0;
                        while (n < n2) {
                            i = genericDeclarationArray[n];
                            this.scannedClasses.put(i, clazz);
                            ++n;
                        }
                    }
                    if (clazz.isAnnotationPresent(Remote.class)) {
                        genericDeclarationArray = clazz.getAnnotation(Remote.class).value();
                        n2 = genericDeclarationArray.length;
                        n = 0;
                        while (n < n2) {
                            i = genericDeclarationArray[n];
                            this.scannedClasses.put(i, clazz);
                            ++n;
                        }
                    }
                    genericDeclarationArray = clazz.getInterfaces();
                    n2 = genericDeclarationArray.length;
                    n = 0;
                    while (n < n2) {
                        i = genericDeclarationArray[n];
                        if (i.isAnnotationPresent(Local.class)) {
                            this.scannedClasses.put(i, clazz);
                        }
                        if (i.isAnnotationPresent(Remote.class)) {
                            this.scannedClasses.put(i, clazz);
                        }
                        ++n;
                    }
                    genericDeclarationArray = clazz.getMethods();
                    n2 = genericDeclarationArray.length;
                    n = 0;
                    while (n < n2) {
                        GenericDeclaration method = genericDeclarationArray[n];
                        if (((AccessibleObject)((Object)method)).isAnnotationPresent(Observer.class)) {
                            Observer o = ((Method)method).getAnnotation(Observer.class);
                            Set<Method> methods = this.observers.get(o.value());
                            if (methods == null) {
                                methods = new HashSet<Method>();
                                this.observers.put(o.value(), methods);
                            }
                            methods.add((Method)method);
                        }
                        ++n;
                    }
                }
            }
            catch (Exception e) {
                log.debug(e, "Could not introspect scanned item: %s", item);
            }
        }
    }

    public Map<Class<?>, Class<?>> getScannedClasses() {
        return this.scannedClasses;
    }

    public Map<String, Set<Method>> getObservers() {
        return this.observers;
    }
}

