/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.ejb;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.NoSuchEJBException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.granite.logging.Logger;
import org.granite.messaging.service.EjbServiceMetadata;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceInvocationContext;
import org.granite.tide.IInvocationCall;
import org.granite.tide.IInvocationResult;
import org.granite.tide.TidePersistenceManager;
import org.granite.tide.TideServiceContext;
import org.granite.tide.annotations.BypassTideMerge;
import org.granite.tide.async.AsyncPublisher;
import org.granite.tide.data.DataContext;
import org.granite.tide.data.JPAPersistenceManager;
import org.granite.tide.ejb.Context;
import org.granite.tide.ejb.EjbIdentity;
import org.granite.tide.ejb.EjbScannedItemHandler;
import org.granite.tide.invocation.ContextEvent;
import org.granite.tide.invocation.ContextUpdate;
import org.granite.tide.invocation.InvocationCall;
import org.granite.tide.invocation.InvocationResult;
import org.granite.tide.util.AbstractContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbServiceContext
extends TideServiceContext {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(EjbServiceContext.class);
    public static final String CAPITALIZED_DESTINATION_ID = "{capitalized.component.name}";
    public static final String DESTINATION_ID = "{component.name}";
    private final transient Map<String, EjbComponent> ejbLookupCache = new ConcurrentHashMap<String, EjbComponent>();
    private final Set<String> remoteObservers = new HashSet<String>();
    private final String lookup;
    private final EjbIdentity identity;
    private String entityManagerFactoryJndiName = null;
    private String entityManagerJndiName = null;

    public EjbServiceContext() throws ServiceException {
        this.lookup = "";
        this.identity = new EjbIdentity();
    }

    public EjbServiceContext(String lookup) throws ServiceException {
        this.lookup = lookup;
        this.identity = new EjbIdentity();
    }

    @Override
    protected AsyncPublisher getAsyncPublisher() {
        return null;
    }

    public void setEntityManagerFactoryJndiName(String entityManagerFactoryJndiName) {
        this.entityManagerFactoryJndiName = entityManagerFactoryJndiName;
    }

    public void setEntityManagerJndiName(String entityManagerJndiName) {
        this.entityManagerJndiName = entityManagerJndiName;
    }

    @Override
    protected TidePersistenceManager getTidePersistenceManager(boolean create) {
        if (!create) {
            return null;
        }
        EntityManager em = this.getEntityManager();
        if (em == null) {
            return null;
        }
        return new JPAPersistenceManager(em);
    }

    private EntityManager getEntityManager() {
        block5: {
            try {
                InitialContext jndiContext = new InitialContext();
                if (this.entityManagerFactoryJndiName != null) {
                    EntityManagerFactory factory = (EntityManagerFactory)jndiContext.lookup(this.entityManagerFactoryJndiName);
                    return factory.createEntityManager();
                }
                if (this.entityManagerJndiName != null) {
                    return (EntityManager)jndiContext.lookup(this.entityManagerJndiName);
                }
            }
            catch (NamingException e) {
                if (this.entityManagerFactoryJndiName != null) {
                    throw new RuntimeException("Unable to find a EntityManagerFactory  for jndiName " + this.entityManagerFactoryJndiName);
                }
                if (this.entityManagerJndiName == null) break block5;
                throw new RuntimeException("Unable to find a EntityManager for jndiName " + this.entityManagerJndiName);
            }
        }
        return null;
    }

    public Object callComponent(Method method, Object ... args) throws Exception {
        String name = method.getDeclaringClass().getSimpleName();
        if ((name = String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1)).endsWith("Bean")) {
            name = name.substring(0, name.length() - "Bean".length());
        }
        Object invokee = this.findComponent(name, null);
        method = invokee.getClass().getMethod(method.getName(), method.getParameterTypes());
        return method.invoke(invokee, args);
    }

    public Set<String> getRemoteObservers() {
        return this.remoteObservers;
    }

    @Override
    public Object findComponent(String componentName, Class<?> componentClass) {
        if ("identity".equals(componentName)) {
            return this.identity;
        }
        EjbComponent component = this.ejbLookupCache.get(componentName);
        if (component != null) {
            return component.ejbInstance;
        }
        String name = componentName;
        if (this.lookup != null) {
            name = this.lookup;
            if (this.lookup.contains(CAPITALIZED_DESTINATION_ID)) {
                name = this.lookup.replace(CAPITALIZED_DESTINATION_ID, this.capitalize(componentName));
            }
            if (this.lookup.contains(DESTINATION_ID)) {
                name = this.lookup.replace(DESTINATION_ID, componentName);
            }
        }
        InitialContext ic = null;
        try {
            ic = new InitialContext();
        }
        catch (Exception e) {
            throw new ServiceException("Could not get InitialContext", e);
        }
        log.debug(">> New EjbServiceInvoker looking up: %s", name);
        try {
            component = new EjbComponent();
            component.ejbInstance = ic.lookup(name);
            component.ejbClasses = new HashSet();
            Class<?> scannedClass = null;
            EjbScannedItemHandler itemHandler = EjbScannedItemHandler.instance();
            Class<?>[] classArray = component.ejbInstance.getClass().getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> i = classArray[n2];
                if (itemHandler.getScannedClasses().containsKey(i)) {
                    scannedClass = itemHandler.getScannedClasses().get(i);
                    break;
                }
                ++n2;
            }
            if (scannedClass == null) {
                scannedClass = itemHandler.getScannedClasses().get(component.ejbInstance.getClass());
            }
            if (scannedClass == null && component.ejbInstance.getClass().getSuperclass() != null) {
                scannedClass = itemHandler.getScannedClasses().get(component.ejbInstance.getClass().getSuperclass());
            }
            if (scannedClass != null) {
                component.ejbClasses.add(scannedClass);
                for (Map.Entry<Class<?>, Class<?>> me : itemHandler.getScannedClasses().entrySet()) {
                    if (!me.getValue().equals(scannedClass)) continue;
                    component.ejbClasses.add(me.getKey());
                }
                component.ejbMetadata = new EjbServiceMetadata(scannedClass, component.ejbInstance.getClass());
            } else {
                log.warn("Ejb " + componentName + " was not scanned: remove method will not be called if it is a Stateful bean. Add META-INF/services-config.properties if needed.", new Object[0]);
            }
            this.ejbLookupCache.put(componentName, component);
            return component.ejbInstance;
        }
        catch (NamingException e) {
            log.error("EJB not found " + name + ": " + e.getMessage(), new Object[0]);
            throw new ServiceException("Could not lookup for: " + name, e);
        }
    }

    @Override
    public Set<Class<?>> findComponentClasses(String componentName, Class<?> componentClass) {
        if ("identity".equals(componentName)) {
            HashSet classes = new HashSet(1);
            classes.add(EjbIdentity.class);
            return classes;
        }
        EjbComponent component = this.ejbLookupCache.get(componentName);
        if (component == null) {
            this.findComponent(componentName, componentClass);
        }
        return this.ejbLookupCache.get((Object)componentName).ejbClasses;
    }

    private String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }

    @Override
    public void prepareCall(ServiceInvocationContext context, IInvocationCall c, String componentName, Class<?> componentClass) {
        if (c instanceof InvocationCall && ((InvocationCall)c).getListeners() != null) {
            this.remoteObservers.addAll(((InvocationCall)c).getListeners());
        }
        Context.create(this);
    }

    @Override
    public IInvocationResult postCall(ServiceInvocationContext context, Object result, String componentName, Class<?> componentClass) {
        try {
            EjbComponent component;
            AbstractContext threadContext = AbstractContext.instance();
            ArrayList<ContextUpdate> results = new ArrayList<ContextUpdate>(threadContext.size());
            DataContext dataContext = DataContext.get();
            Set<Object[]> dataUpdates = dataContext != null ? dataContext.getDataUpdates() : null;
            Object[][] updates = null;
            if (dataUpdates != null && !dataUpdates.isEmpty()) {
                updates = (Object[][])dataUpdates.toArray((T[])new Object[dataUpdates.size()][]);
            }
            for (Map.Entry entry : threadContext.entrySet()) {
                results.add(new ContextUpdate((String)entry.getKey(), null, entry.getValue(), 3, false));
            }
            InvocationResult ires = new InvocationResult(result, results);
            if (context.getBean() != null) {
                if (context.getBean().getClass().isAnnotationPresent(BypassTideMerge.class)) {
                    ires.setMerge(false);
                } else {
                    try {
                        Method m = context.getBean().getClass().getMethod(context.getMethod().getName(), context.getMethod().getParameterTypes());
                        if (m.isAnnotationPresent(BypassTideMerge.class)) {
                            ires.setMerge(false);
                        }
                    }
                    catch (Exception e) {
                        log.warn("Could not find bean method", e);
                    }
                }
            }
            ires.setUpdates(updates);
            ires.setEvents(new ArrayList<ContextEvent>(threadContext.getRemoteEvents()));
            if (componentName != null && (component = this.ejbLookupCache.get(componentName)) != null && component.ejbMetadata != null && component.ejbMetadata.isStateful() && component.ejbMetadata.isRemoveMethod(context.getMethod())) {
                this.ejbLookupCache.remove(componentName);
            }
            InvocationResult invocationResult = ires;
            return invocationResult;
        }
        finally {
            AbstractContext.remove();
        }
    }

    @Override
    public void postCallFault(ServiceInvocationContext context, Throwable t, String componentName, Class<?> componentClass) {
        try {
            if (componentName != null) {
                EjbComponent component = this.ejbLookupCache.get(componentName);
                if (t instanceof NoSuchEJBException || component != null && component.ejbMetadata != null && component.ejbMetadata.isStateful() && component.ejbMetadata.isRemoveMethod(context.getMethod()) && !component.ejbMetadata.getRetainIfException(context.getMethod())) {
                    this.ejbLookupCache.remove(componentName);
                }
            }
        }
        finally {
            AbstractContext.remove();
        }
    }

    private static class EjbComponent {
        public Object ejbInstance;
        public Set<Class<?>> ejbClasses;
        public EjbServiceMetadata ejbMetadata;

        private EjbComponent() {
        }
    }
}

