/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.jbossweb;

import flex.messaging.messages.CommandMessage;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.AbstractGravityServlet;
import org.granite.gravity.AsyncHttpContext;
import org.granite.gravity.GravityConfig;
import org.granite.gravity.jbossweb.EventUtil;
import org.granite.logging.Logger;
import org.jboss.servlet.http.HttpEvent;

public class JBossWebChannel
extends AbstractChannel {
    private static final Logger log = Logger.getLogger(JBossWebChannel.class);
    private final AtomicReference<HttpEvent> event = new AtomicReference();

    public JBossWebChannel(ServletConfig servletConfig, GravityConfig gravityConfig, String id) {
        super(servletConfig, gravityConfig, id);
    }

    public void setHttpEvent(HttpEvent event) {
        HttpEvent previousEvent;
        if (log.isDebugEnabled()) {
            log.debug("Channel: %s got new event: %s", this.getId(), EventUtil.toString(event));
        }
        if ((previousEvent = this.event.getAndSet(event)) != null) {
            if (event != null) {
                log.warn("Got a new non null event %s while current event %s isn't null", EventUtil.toString(event), EventUtil.toString(this.event.get()));
            }
            if (previousEvent != event) {
                try {
                    previousEvent.close();
                }
                catch (Exception e) {
                    log.debug(e, "Error while closing event", new Object[0]);
                }
            }
        }
        if (event != null) {
            this.queueReceiver();
        }
    }

    protected boolean hasAsyncHttpContext() {
        return this.event.get() != null;
    }

    protected AsyncHttpContext acquireAsyncHttpContext() {
        CommandMessage requestMessage;
        HttpServletResponse response;
        HttpServletRequest request;
        AsyncHttpContext context;
        HttpEvent event;
        block23: {
            block24: {
                block21: {
                    block22: {
                        event = this.event.getAndSet(null);
                        if (event == null) {
                            return null;
                        }
                        context = null;
                        try {
                            request = null;
                            response = null;
                            try {
                                request = event.getHttpServletRequest();
                                response = event.getHttpServletResponse();
                            }
                            catch (Exception e) {
                                log.warn(e, "Illegal event: %s", EventUtil.toString(event));
                                if (context == null) {
                                    try {
                                        event.close();
                                    }
                                    catch (Exception e2) {
                                        log.debug(e2, "Error while closing event: %s", EventUtil.toString(event));
                                    }
                                }
                                return null;
                            }
                        }
                        catch (Throwable throwable) {
                            if (context == null) {
                                try {
                                    event.close();
                                }
                                catch (Exception e) {
                                    log.debug(e, "Error while closing event: %s", EventUtil.toString(event));
                                }
                            }
                            throw throwable;
                        }
                        if (request != null && response != null) break block21;
                        log.warn("Illegal event (request or response is null): %s", EventUtil.toString(event));
                        if (context != null) break block22;
                        try {
                            event.close();
                        }
                        catch (Exception e) {
                            log.debug(e, "Error while closing event: %s", EventUtil.toString(event));
                        }
                    }
                    return null;
                }
                requestMessage = AbstractGravityServlet.getConnectMessage(request);
                if (requestMessage != null) break block23;
                log.warn("No request message while running channel: %s", this.getId());
                if (context != null) break block24;
                try {
                    event.close();
                }
                catch (Exception e) {
                    log.debug(e, "Error while closing event: %s", EventUtil.toString(event));
                }
            }
            return null;
        }
        context = new AsyncHttpContext(request, response, requestMessage, event);
        if (context == null) {
            try {
                event.close();
            }
            catch (Exception e) {
                log.debug(e, "Error while closing event: %s", EventUtil.toString(event));
            }
        }
        return context;
    }

    protected void releaseAsyncHttpContext(AsyncHttpContext context) {
        try {
            if (context != null && context.getObject() != null) {
                ((HttpEvent)context.getObject()).close();
            }
        }
        catch (Exception e) {
            log.debug(e, "Could not release event for channel: %s", this);
        }
    }

    public void destroy() {
        try {
            super.destroy();
        }
        catch (Throwable throwable) {
            HttpEvent event = this.event.getAndSet(null);
            if (event != null) {
                try {
                    event.close();
                }
                catch (Exception e) {
                    log.debug(e, "Could not close event: %s for channel: %s", EventUtil.toString(event), this);
                }
            }
            throw throwable;
        }
        HttpEvent event = this.event.getAndSet(null);
        if (event != null) {
            try {
                event.close();
            }
            catch (Exception e) {
                log.debug(e, "Could not close event: %s for channel: %s", EventUtil.toString(event), this);
            }
        }
    }
}

