/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service.security;

import java.io.UnsupportedEncodingException;
import org.granite.messaging.service.security.AbstractSecurityContext;
import org.granite.messaging.service.security.SecurityService;
import org.granite.messaging.service.security.SecurityServiceException;
import org.granite.util.Base64;

public abstract class AbstractSecurityService
implements SecurityService {
    public static final String AUTH_TYPE = "granite-security";

    protected void startAuthorization(AbstractSecurityContext context) throws Exception {
        Object credentials = context.getMessage().getHeaders().get("DSRemoteCredentials");
        if (credentials != null && !"".equals(credentials)) {
            this.login(credentials);
        }
    }

    protected Object endAuthorization(AbstractSecurityContext context) throws Exception {
        return context.invoke();
    }

    protected String[] decodeBase64Credentials(Object credentials) {
        if (!(credentials instanceof String)) {
            throw new IllegalArgumentException("Credentials should be a non null String: " + (credentials != null ? credentials.getClass().getName() : null));
        }
        byte[] bytes = Base64.decode((String)credentials);
        String decoded = "";
        try {
            decoded = new String(bytes, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw SecurityServiceException.newInvalidCredentialsException("ISO-8859-1 encoding not supported ???");
        }
        int colon = decoded.indexOf(58);
        if (colon == -1) {
            throw SecurityServiceException.newInvalidCredentialsException("No colon");
        }
        return new String[]{decoded.substring(0, colon), decoded.substring(colon + 1)};
    }

    public void handleSecurityException(SecurityServiceException e) {
    }
}

