/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.webapp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.granite.logging.Logger;
import org.granite.util.ServletParams;

public class DumpFilter
implements Filter {
    private static final Logger log = Logger.getLogger(DumpFilter.class);
    private static final String HEXS = "0123456789ABCDEF";
    private static final String DUMP_DIR = "dumpDir";
    File dumpDir = null;

    public void init(FilterConfig config) throws ServletException {
        String dumpDirString = ServletParams.get(config, DUMP_DIR, String.class, null);
        if (dumpDirString != null) {
            File dumpDir = new File(dumpDirString);
            if (!(dumpDir.exists() && dumpDir.isDirectory() && dumpDir.canWrite())) {
                log.warn("Ignoring dump directory (is it a writable directory?): %s", dumpDir);
            } else {
                this.dumpDir = dumpDir;
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        DumpRequestWrapper requestWrapper = new DumpRequestWrapper((HttpServletRequest)request);
        DumpResponseWrapper responseWrapper = new DumpResponseWrapper((HttpServletResponse)response);
        this.dumpBytes("request", requestWrapper.getBytes());
        chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
        this.dumpBytes("response", responseWrapper.getBytes());
    }

    public void destroy() {
        this.dumpDir = null;
    }

    private void dumpBytes(String label, byte[] bytes) {
        block18: {
            StringBuilder hexSb = new StringBuilder();
            StringBuilder charSb = new StringBuilder();
            int i = 0;
            while (i < bytes.length) {
                int b = bytes[i] & 0xFF;
                if (hexSb.length() > 0) {
                    hexSb.append(' ');
                    charSb.append(' ');
                }
                hexSb.append(HEXS.charAt(b >> 4)).append(HEXS.charAt(b & 0xF));
                if (b >= 32 && b <= 126) {
                    charSb.append(' ').append((char)b);
                } else {
                    charSb.append("##");
                }
                ++i;
            }
            log.info("[RAW %s] {\n%s\n%s\n}", label.toUpperCase(), hexSb.toString(), charSb.toString());
            if (this.dumpDir != null) {
                File file = new File(String.valueOf(this.dumpDir.getPath()) + File.separator + label + "_" + System.currentTimeMillis() + ".amf");
                int i2 = 1;
                while (i2 < 100 && file.exists()) {
                    file = new File(String.valueOf(file.getAbsolutePath()) + "." + i2);
                    ++i2;
                }
                FileOutputStream os = null;
                try {
                    try {
                        os = new FileOutputStream(file);
                        ((OutputStream)os).write(bytes);
                    }
                    catch (Exception e) {
                        log.error(e, "Could not write dump file: %s", file);
                        if (os == null) break block18;
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (Exception exception) {}
                    }
                }
                finally {
                    if (os != null) {
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    class DumpRequestWrapper
    extends HttpServletRequestWrapper {
        private byte[] bytes;

        public DumpRequestWrapper(HttpServletRequest request) throws IOException {
            super(request);
            this.bytes = null;
            this.setCharacterEncoding("UTF-8");
            ServletInputStream is = null;
            try {
                is = request.getInputStream();
                ByteArrayOutputStream out = new ByteArrayOutputStream(128);
                int b = is.read();
                while (b != -1) {
                    out.write(b);
                    b = is.read();
                }
                this.bytes = out.toByteArray();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public ServletInputStream getInputStream() throws IOException {
            final ByteArrayInputStream bais = new ByteArrayInputStream(this.bytes);
            return new ServletInputStream(){

                public int read() throws IOException {
                    return bais.read();
                }
            };
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }

    class DumpResponseWrapper
    extends HttpServletResponseWrapper {
        private ByteArrayOutputStream baos;
        private ServletOutputStream out;

        public DumpResponseWrapper(HttpServletResponse response) throws IOException {
            super(response);
            this.baos = new ByteArrayOutputStream(256);
            this.out = null;
            this.out = response.getOutputStream();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return new ServletOutputStream(){

                public void write(int b) throws IOException {
                    DumpResponseWrapper.this.baos.write(b);
                    DumpResponseWrapper.this.out.write(b);
                }
            };
        }

        public byte[] getBytes() {
            return this.baos.toByteArray();
        }
    }
}

