/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.data;

import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.util.ClassGetter;
import org.granite.tide.TidePersistenceManager;
import org.granite.tide.TideTransactionManager;
import org.granite.tide.data.TideTransactionPersistenceManager;
import org.granite.util.Reflections;

public abstract class AbstractTidePersistenceManager
implements TidePersistenceManager {
    private static final Logger log = Logger.getLogger(AbstractTidePersistenceManager.class);
    protected TideTransactionManager tm;

    public AbstractTidePersistenceManager(TideTransactionManager tm) {
        this.tm = tm;
        if (this.tm == null) {
            throw new RuntimeException("transaction manager is null");
        }
    }

    public Object attachEntity(Object entity, String[] propertyNames) {
        return this.attachEntity(this, entity, propertyNames);
    }

    public Object attachEntity(TidePersistenceManager pm, Object entity, String[] propertyNames) {
        Object attachedEntity = null;
        ClassGetter getter = GraniteContext.getCurrentInstance().getGraniteConfig().getClassGetter();
        Object tx = this.tm.begin(pm instanceof TideTransactionPersistenceManager ? (TideTransactionPersistenceManager)((Object)pm) : null);
        if (tx == null) {
            throw new RuntimeException("Could not initiate transaction for lazy initialization");
        }
        try {
            attachedEntity = propertyNames != null ? this.findEntity(entity, propertyNames) : entity;
            if (attachedEntity != null && propertyNames != null) {
                int i = 0;
                while (i < propertyNames.length) {
                    Object initializedObj = Reflections.getGetterMethod(attachedEntity.getClass(), propertyNames[i]).invoke(attachedEntity, new Object[0]);
                    if (getter != null) {
                        getter.initialize(entity, propertyNames[i], initializedObj);
                    }
                    ++i;
                }
            }
            this.tm.commit(tx);
        }
        catch (Exception e) {
            String propertyName = propertyNames != null && propertyNames.length > 0 ? propertyNames[0] : "";
            log.error(e, "Error during lazy-initialization of collection: %s", propertyName);
            this.tm.rollback(tx);
        }
        return attachedEntity;
    }

    public abstract Object findEntity(Object var1, String[] var2);
}

