/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service;

import flex.messaging.messages.Message;
import org.granite.config.flex.Destination;
import org.granite.logging.Logger;
import org.granite.messaging.service.AbstractServiceExceptionHandler;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceInvocationContext;
import org.granite.messaging.service.security.SecurityServiceException;

public class DefaultServiceExceptionHandler
extends AbstractServiceExceptionHandler {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(DefaultServiceExceptionHandler.class);

    public DefaultServiceExceptionHandler() {
        this(true);
    }

    public DefaultServiceExceptionHandler(boolean logException) {
        super(logException);
    }

    public ServiceException handleNoSuchMethodException(Message request, Destination destination, Object invokee, String method, Object[] args, NoSuchMethodException e) {
        if (this.getLogException()) {
            log.error(e, "Could not process remoting message: %s", request);
        }
        return this.getServiceException(request, destination, method, e);
    }

    public ServiceException handleInvocationException(ServiceInvocationContext context, Throwable e) {
        if (this.getLogException()) {
            if (e instanceof SecurityServiceException) {
                log.debug(e, "Could not process remoting message: %s", context.getMessage());
            } else {
                log.error(e, "Could not process remoting message: %s", context.getMessage());
            }
        }
        return this.getServiceException(context, e);
    }
}

