/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.data;

import java.util.HashSet;
import java.util.Set;
import org.granite.tide.data.DataDispatcher;
import org.granite.tide.data.DataEnabled;
import org.granite.tide.data.DataTopicParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataContext {
    private static ThreadLocal<DataContext> dataContext = new ThreadLocal();
    private DataDispatcher dataDispatcher = null;
    private DataEnabled.PublishMode publishMode = null;
    private final Set<Object[]> dataUpdates = new HashSet<Object[]>();

    public static void init(String topic, Class<? extends DataTopicParams> dataTopicParamsClass, DataEnabled.PublishMode publishMode) {
        DataContext dc = new DataContext(topic, dataTopicParamsClass, publishMode);
        dataContext.set(dc);
    }

    private DataContext(String topic, Class<? extends DataTopicParams> dataTopicParamsClass, DataEnabled.PublishMode publishMode) {
        this.dataDispatcher = new DataDispatcher(topic, dataTopicParamsClass);
        this.publishMode = publishMode;
    }

    public static DataContext get() {
        return dataContext.get();
    }

    public static void remove() {
        dataContext.remove();
    }

    public Set<Object[]> getDataUpdates() {
        return this.dataUpdates;
    }

    public static void addUpdate(EntityUpdateType type, Object entity) {
        DataContext dc = DataContext.get();
        if (dc != null) {
            dc.dataUpdates.add(new Object[]{type.name(), entity});
        }
    }

    public static void observe() {
        DataContext dc = DataContext.get();
        if (dc != null) {
            dc.dataDispatcher.observe();
        }
    }

    public static void publish() {
        DataContext.publish(DataEnabled.PublishMode.MANUAL);
    }

    public static void publish(DataEnabled.PublishMode publishMode) {
        DataContext dc = DataContext.get();
        if (dc != null && !dc.dataUpdates.isEmpty() && (publishMode == DataEnabled.PublishMode.MANUAL || dc.publishMode.equals((Object)publishMode))) {
            dc.dataDispatcher.publish(dc.dataUpdates);
            dc.dataUpdates.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntityUpdateType {
        PERSIST,
        UPDATE,
        REMOVE;

    }
}

