/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config.flex;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.granite.config.GraniteConfig;
import org.granite.config.ServletGraniteConfig;
import org.granite.config.api.Configuration;
import org.granite.config.flex.ServicesConfig;
import org.granite.util.ServletParams;

public class ServletServicesConfig {
    private static final String SERVICES_CONFIG_KEY = String.valueOf(ServletServicesConfig.class.getName()) + "_CACHE";
    private ServicesConfig config = null;

    private ServletServicesConfig(ServletContext context, ServicesConfig config) {
        this.config = config;
    }

    public static synchronized ServletServicesConfig getServletConfig(ServletContext context) {
        return (ServletServicesConfig)context.getAttribute(SERVICES_CONFIG_KEY);
    }

    public static synchronized ServicesConfig loadConfig(ServletContext context) throws ServletException {
        ServletServicesConfig servletServicesConfig = (ServletServicesConfig)context.getAttribute(SERVICES_CONFIG_KEY);
        if (servletServicesConfig == null) {
            String path = null;
            Configuration configuration = (Configuration)context.getAttribute(ServletGraniteConfig.GRANITE_CONFIG_CONFIGURATION_KEY);
            if (configuration != null) {
                path = configuration.getFlexServicesConfig();
            }
            if (path == null) {
                path = ServletParams.get(context, "servicesConfigPath", String.class, null);
            }
            if (path == null) {
                path = "/WEB-INF/flex/services-config.xml";
            }
            InputStream is = context.getResourceAsStream(path);
            try {
                try {
                    GraniteConfig graniteConfig = ServletGraniteConfig.loadConfig(context);
                    ServicesConfig servicesConfig = new ServicesConfig(is, configuration, graniteConfig.getScan());
                    servletServicesConfig = ServletServicesConfig.loadConfig(context, servicesConfig);
                }
                catch (Exception e) {
                    throw new ServletException("Could not load custom services-config.xml", (Throwable)e);
                }
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
            context.setAttribute(SERVICES_CONFIG_KEY, (Object)servletServicesConfig);
        }
        return servletServicesConfig.config;
    }

    public static synchronized ServletServicesConfig loadConfig(ServletContext context, ServicesConfig servicesConfig) {
        ServletServicesConfig servletServicesConfig = new ServletServicesConfig(context, servicesConfig);
        context.setAttribute(SERVICES_CONFIG_KEY, (Object)servletServicesConfig);
        return servletServicesConfig;
    }
}

