/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.adapters;

import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.granite.clustering.GraniteDistributedDataFactory;
import org.granite.clustering.TransientReference;
import org.granite.context.GraniteContext;
import org.granite.gravity.Channel;
import org.granite.gravity.MessageReceivingException;
import org.granite.gravity.adapters.JMSClient;
import org.granite.gravity.adapters.ServiceAdapter;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.AMF3Deserializer;
import org.granite.messaging.amf.io.AMF3Serializer;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.util.XMap;

public class JMSServiceAdapter
extends ServiceAdapter {
    private static final Logger log = Logger.getLogger(JMSServiceAdapter.class);
    public static final long DEFAULT_FAILOVER_RETRY_INTERVAL = 1000L;
    public static final int DEFAULT_FAILOVER_RETRY_COUNT = 4;
    protected ConnectionFactory jmsConnectionFactory = null;
    protected Destination jmsDestination = null;
    protected Map<String, JMSClient> jmsClients = new HashMap<String, JMSClient>();
    protected String destinationName = null;
    protected boolean textMessages = false;
    protected boolean transactedSessions = false;
    protected int acknowledgeMode = 1;
    protected int messagePriority = 4;
    protected int deliveryMode = 2;
    protected boolean noLocal = false;
    protected boolean sessionSelector = false;
    protected long failoverRetryInterval = 1000L;
    protected int failoverRetryCount = 4;

    public void configure(XMap adapterProperties, XMap destinationProperties) throws ServiceException {
        String ackMode;
        super.configure(adapterProperties, destinationProperties);
        log.info("Using JMS configuration: %s", destinationProperties.getOne("jms"));
        this.destinationName = destinationProperties.get("jms/destination-name");
        if (Boolean.TRUE.toString().equals(destinationProperties.get("jms/transacted-sessions"))) {
            this.transactedSessions = true;
        }
        if ("AUTO_ACKNOWLEDGE".equals(ackMode = destinationProperties.get("jms/acknowledge-mode"))) {
            this.acknowledgeMode = 1;
        } else if ("CLIENT_ACKNOWLEDGE".equals(ackMode)) {
            this.acknowledgeMode = 2;
        } else if ("DUPS_OK_ACKNOWLEDGE".equals(ackMode)) {
            this.acknowledgeMode = 3;
        } else if (ackMode != null) {
            log.warn("Unsupported acknowledge mode: %s (using default AUTO_ACKNOWLEDGE)", ackMode);
        }
        if ("javax.jms.TextMessage".equals(destinationProperties.get("jms/message-type"))) {
            this.textMessages = true;
        }
        if (Boolean.TRUE.toString().equals(destinationProperties.get("jms/no-local"))) {
            this.noLocal = true;
        }
        if (Boolean.TRUE.toString().equals(destinationProperties.get("session-selector"))) {
            this.sessionSelector = true;
        }
        this.failoverRetryInterval = destinationProperties.get("jms/failover-retry-interval", Long.TYPE, 1000L);
        if (this.failoverRetryInterval <= 0L) {
            log.warn("Illegal failover retry interval: %d (using default %d)", this.failoverRetryInterval, 1000L);
            this.failoverRetryInterval = 1000L;
        }
        this.failoverRetryCount = destinationProperties.get("jms/failover-retry-count", Integer.TYPE, 4);
        if (this.failoverRetryCount <= 0) {
            log.warn("Illegal failover retry count: %s (using default %d)", this.failoverRetryCount, 4);
            this.failoverRetryCount = 4;
        }
        Properties environment = new Properties();
        for (XMap property : destinationProperties.getAll("jms/initial-context-environment/property")) {
            String name = property.get("name");
            String value = property.get("value");
            if ("Context.PROVIDER_URL".equals(name)) {
                environment.put("java.naming.provider.url", value);
                continue;
            }
            if ("Context.INITIAL_CONTEXT_FACTORY".equals(name)) {
                environment.put("java.naming.factory.initial", value);
                continue;
            }
            if ("Context.URL_PKG_PREFIXES".equals(name)) {
                environment.put("java.naming.factory.url.pkgs", value);
                continue;
            }
            if ("Context.SECURITY_PRINCIPAL".equals(name)) {
                environment.put("java.naming.security.principal", value);
                continue;
            }
            if ("Context.SECURITY_CREDENTIALS".equals(name)) {
                environment.put("java.naming.security.credentials", value);
                continue;
            }
            log.warn("Unknown InitialContext property: %s (ignored)", name);
        }
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext(environment.size() > 0 ? environment : null);
        }
        catch (NamingException e) {
            log.error(e, "Could not initialize JNDI context", new Object[0]);
            throw new ServiceException("Error configuring JMS Adapter", e);
        }
        String cfJndiName = destinationProperties.get("jms/connection-factory");
        try {
            this.jmsConnectionFactory = (ConnectionFactory)initialContext.lookup(cfJndiName);
        }
        catch (NamingException e) {
            log.error(e, "Could not find JMS ConnectionFactory named %s in JNDI", cfJndiName);
            throw new ServiceException("Error configuring JMS Adapter", e);
        }
        String dsJndiName = destinationProperties.get("jms/destination-jndi-name");
        try {
            this.jmsDestination = (Destination)initialContext.lookup(dsJndiName);
        }
        catch (NamingException e) {
            log.error(e, "Could not find JMS destination named %s in JNDI", dsJndiName);
            throw new ServiceException("Error configuring JMS Adapter", e);
        }
    }

    protected Destination getProducerDestination(String topic) {
        return this.jmsDestination;
    }

    protected Destination getConsumerDestination(String topic) {
        return this.jmsDestination;
    }

    public void start() throws ServiceException {
        super.start();
    }

    public void stop() throws ServiceException {
        super.stop();
        for (JMSClient jmsClient : this.jmsClients.values()) {
            try {
                jmsClient.close();
            }
            catch (Exception e) {
                log.warn(e, "Could not close JMSClient: %s", jmsClient);
            }
        }
        this.jmsClients.clear();
    }

    private synchronized JMSClient connectJMSClient(Channel client, String destination) throws Exception {
        JMSClient jmsClient = this.jmsClients.get(client.getId());
        if (jmsClient == null) {
            jmsClient = new JMSClientImpl(client);
            jmsClient.connect();
            this.jmsClients.put(client.getId(), jmsClient);
            if (this.sessionSelector && GraniteContext.getCurrentInstance() instanceof HttpGraniteContext) {
                ((HttpGraniteContext)GraniteContext.getCurrentInstance()).getSessionMap().put("org.granite.gravity.jmsClient." + destination, jmsClient);
            }
            log.debug("JMS client connected for channel " + client.getId(), new Object[0]);
        }
        return jmsClient;
    }

    private synchronized void closeJMSClientIfNecessary(Channel client, String destination) throws Exception {
        JMSClient jmsClient = this.jmsClients.get(client.getId());
        if (jmsClient != null && !jmsClient.hasActiveConsumer()) {
            jmsClient.close();
            this.jmsClients.remove(client.getId());
            if (this.sessionSelector && GraniteContext.getCurrentInstance() instanceof HttpGraniteContext) {
                ((HttpGraniteContext)GraniteContext.getCurrentInstance()).getSessionMap().remove("org.granite.gravity.jmsClient." + destination);
            }
            log.debug("JMS client closed for channel " + client.getId(), new Object[0]);
        }
    }

    public Object invoke(Channel fromClient, AsyncMessage message) {
        try {
            JMSClient jmsClient = this.connectJMSClient(fromClient, message.getDestination());
            jmsClient.send(message);
            AcknowledgeMessage reply = new AcknowledgeMessage(message);
            reply.setMessageId(message.getMessageId());
            return reply;
        }
        catch (Exception e) {
            log.error(e, "Error sending message", new Object[0]);
            ErrorMessage error = new ErrorMessage((Message)message, null);
            error.setFaultString("JMS Adapter error " + e.getMessage());
            return error;
        }
    }

    public Object manage(Channel fromChannel, CommandMessage message) {
        if (message.getOperation() == 0) {
            try {
                JMSClient jmsClient = this.connectJMSClient(fromChannel, message.getDestination());
                jmsClient.subscribe(message);
                AcknowledgeMessage reply = new AcknowledgeMessage(message);
                return reply;
            }
            catch (Exception e) {
                throw new RuntimeException("JMSAdapter subscribe error on topic: " + message, e);
            }
        }
        if (message.getOperation() == 1) {
            try {
                JMSClient jmsClient = this.connectJMSClient(fromChannel, message.getDestination());
                jmsClient.unsubscribe(message);
                this.closeJMSClientIfNecessary(fromChannel, message.getDestination());
                AcknowledgeMessage reply = new AcknowledgeMessage(message);
                return reply;
            }
            catch (Exception e) {
                throw new RuntimeException("JMSAdapter unsubscribe error on topic: " + message, e);
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @TransientReference
    private class JMSClientImpl
    implements JMSClient {
        private Channel channel = null;
        private String topic = null;
        private Connection jmsConnection = null;
        private Session jmsProducerSession = null;
        private MessageProducer jmsProducer = null;
        private Map<String, JMSConsumer> consumers = new HashMap<String, JMSConsumer>();
        private boolean useGlassFishNoCommitWorkaround = false;

        public JMSClientImpl(Channel channel) {
            this.channel = channel;
        }

        @Override
        public boolean hasActiveConsumer() {
            return this.consumers != null && !this.consumers.isEmpty();
        }

        @Override
        public void connect() throws ServiceException {
            try {
                this.jmsConnection = JMSServiceAdapter.this.jmsConnectionFactory.createConnection();
                this.jmsConnection.start();
            }
            catch (JMSException e) {
                throw new ServiceException("JMS Initialize error", e);
            }
        }

        @Override
        public void close() throws ServiceException {
            block37: {
                try {
                    try {
                        if (this.jmsProducer != null) {
                            this.jmsProducer.close();
                        }
                    }
                    catch (JMSException e) {
                        log.error(e, "Could not close JMS Producer for channel " + this.channel.getId(), new Object[0]);
                        try {
                            if (this.jmsProducerSession != null) {
                                this.jmsProducerSession.close();
                            }
                            break block37;
                        }
                        catch (JMSException e2) {
                            log.error(e2, "Could not close JMS Producer Session for channel " + this.channel.getId(), new Object[0]);
                        }
                        break block37;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (this.jmsProducerSession != null) {
                            this.jmsProducerSession.close();
                        }
                    }
                    catch (JMSException e) {
                        log.error(e, "Could not close JMS Producer Session for channel " + this.channel.getId(), new Object[0]);
                    }
                    throw throwable;
                }
                try {
                    if (this.jmsProducerSession != null) {
                        this.jmsProducerSession.close();
                    }
                }
                catch (JMSException e) {
                    log.error(e, "Could not close JMS Producer Session for channel " + this.channel.getId(), new Object[0]);
                }
            }
            for (JMSConsumer consumer : this.consumers.values()) {
                try {
                    consumer.close();
                }
                catch (JMSException e) {
                    log.error(e, "Could not close JMS Consumer " + consumer.subscriptionId + " for channel " + this.channel.getId(), new Object[0]);
                }
            }
            try {
                try {
                    this.jmsConnection.stop();
                }
                catch (JMSException e) {
                    log.debug(e, "Could not stop JMS Connection for channel " + this.channel.getId(), new Object[0]);
                    try {
                        try {
                            this.jmsConnection.close();
                        }
                        catch (JMSException e3) {
                            throw new ServiceException("JMS Stop error", e3);
                        }
                    }
                    finally {
                        this.consumers.clear();
                    }
                }
            }
            finally {
                try {
                    try {
                        this.jmsConnection.close();
                    }
                    catch (JMSException e) {
                        throw new ServiceException("JMS Stop error", e);
                    }
                }
                finally {
                    this.consumers.clear();
                }
            }
        }

        @Override
        public void send(AsyncMessage message) throws Exception {
            Object msg = null;
            if (Boolean.TRUE.equals(message.getHeader("GDS_BYTEARRAY_BODY"))) {
                byte[] byteArray = (byte[])message.getBody();
                ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
                AMF3Deserializer deser = new AMF3Deserializer(bais);
                msg = deser.readObject();
            } else {
                msg = message.getBody();
            }
            this.internalSend(message.getHeaders(), msg, message.getMessageId(), message.getCorrelationId(), message.getTimestamp(), message.getTimeToLive());
        }

        @Override
        public void send(Map<String, ?> params, Object msg, long timeToLive) throws Exception {
            this.internalSend(params, msg, null, null, new Date().getTime(), timeToLive);
        }

        public void internalSend(Map<String, ?> headers, Object msg, String messageId, String correlationId, long timestamp, long timeToLive) throws Exception {
            if (this.jmsProducerSession == null) {
                this.jmsProducerSession = this.jmsConnection.createSession(JMSServiceAdapter.this.transactedSessions, JMSServiceAdapter.this.acknowledgeMode);
                log.debug("Created JMS Producer Session for channel %s (transacted: %s, ack: %s)", this.channel.getId(), JMSServiceAdapter.this.transactedSessions, JMSServiceAdapter.this.acknowledgeMode);
            }
            if (this.jmsProducer == null) {
                try {
                    int retryCount = JMSServiceAdapter.this.failoverRetryCount;
                    while (true) {
                        try {
                            this.jmsProducer = this.jmsProducerSession.createProducer(JMSServiceAdapter.this.getProducerDestination(this.topic));
                        }
                        catch (Exception e) {
                            if (retryCount <= 0) {
                                throw e;
                            }
                            if (log.isDebugEnabled()) {
                                log.debug(e, "Could not create JMS Producer (retrying %d time)", retryCount);
                            } else {
                                log.info("Could not create JMS Producer (retrying %d time)", retryCount);
                            }
                            try {
                                Thread.sleep(JMSServiceAdapter.this.failoverRetryInterval);
                                continue;
                            }
                            catch (Exception f) {
                                throw new ServiceException("Could not sleep when retrying to create JMS Producer", f.getMessage(), e);
                            }
                            if (retryCount-- > 0) continue;
                        }
                        break;
                    }
                    this.jmsProducer.setPriority(JMSServiceAdapter.this.messagePriority);
                    this.jmsProducer.setDeliveryMode(JMSServiceAdapter.this.deliveryMode);
                    log.debug("Created JMS Producer for channel %s", this.channel.getId());
                }
                catch (JMSException e) {
                    this.jmsProducerSession.close();
                    this.jmsProducerSession = null;
                    throw e;
                }
            }
            Object jmsMessage = null;
            jmsMessage = JMSServiceAdapter.this.textMessages ? this.jmsProducerSession.createTextMessage(msg.toString()) : this.jmsProducerSession.createObjectMessage((Serializable)msg);
            jmsMessage.setJMSMessageID(this.normalizeJMSMessageID(messageId));
            jmsMessage.setJMSCorrelationID(this.normalizeJMSMessageID(correlationId));
            jmsMessage.setJMSTimestamp(timestamp);
            jmsMessage.setJMSExpiration(timeToLive);
            for (Map.Entry<String, ?> me : headers.entrySet()) {
                if ("JMSType".equals(me.getKey())) {
                    if (!(me.getValue() instanceof String)) continue;
                    jmsMessage.setJMSType((String)me.getValue());
                    continue;
                }
                if ("JMSPriority".equals(me.getKey())) {
                    if (!(me.getValue() instanceof Integer)) continue;
                    jmsMessage.setJMSPriority(((Integer)me.getValue()).intValue());
                    continue;
                }
                if (me.getValue() instanceof String) {
                    jmsMessage.setStringProperty(me.getKey(), (String)me.getValue());
                    continue;
                }
                if (me.getValue() instanceof Boolean) {
                    jmsMessage.setBooleanProperty(me.getKey(), ((Boolean)me.getValue()).booleanValue());
                    continue;
                }
                if (me.getValue() instanceof Integer) {
                    jmsMessage.setIntProperty(me.getKey(), ((Integer)me.getValue()).intValue());
                    continue;
                }
                if (me.getValue() instanceof Long) {
                    jmsMessage.setLongProperty(me.getKey(), ((Long)me.getValue()).longValue());
                    continue;
                }
                if (me.getValue() instanceof Double) {
                    jmsMessage.setDoubleProperty(me.getKey(), ((Double)me.getValue()).doubleValue());
                    continue;
                }
                jmsMessage.setObjectProperty(me.getKey(), me.getValue());
            }
            this.jmsProducer.send((javax.jms.Message)jmsMessage);
            if (JMSServiceAdapter.this.transactedSessions && !this.useGlassFishNoCommitWorkaround) {
                try {
                    this.jmsProducerSession.commit();
                }
                catch (JMSException e) {
                    if (e.getMessage() != null && e.getMessage().startsWith("MQJMSRA_DS4001")) {
                        this.useGlassFishNoCommitWorkaround = true;
                    }
                    log.error(e, "Could not commit JMS Session for channel %s", this.channel.getId());
                }
            }
        }

        private String normalizeJMSMessageID(String messageId) {
            if (messageId != null && !messageId.startsWith("ID:")) {
                messageId = "ID:" + messageId;
            }
            return messageId;
        }

        @Override
        public void subscribe(CommandMessage message) throws Exception {
            String subscriptionId = (String)message.getHeader("DSDstClientId");
            String selector = (String)message.getHeader("DSSelector");
            this.topic = (String)message.getHeader("DSSubtopic");
            this.internalSubscribe(subscriptionId, selector, message.getDestination(), this.topic);
        }

        @Override
        public void subscribe(String selector, String destination, String topic) throws Exception {
            String subscriptionId;
            if (GraniteContext.getCurrentInstance() instanceof HttpGraniteContext && (subscriptionId = GraniteDistributedDataFactory.getInstance().getDestinationSubscriptionId(destination)) != null) {
                this.internalSubscribe(subscriptionId, selector, destination, topic);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void internalSubscribe(String subscriptionId, String selector, String destination, String topic) throws Exception {
            Map<String, JMSConsumer> map = this.consumers;
            synchronized (map) {
                JMSConsumer consumer = this.consumers.get(subscriptionId);
                if (consumer == null) {
                    consumer = new JMSConsumer(subscriptionId, selector, JMSServiceAdapter.this.noLocal);
                    this.consumers.put(subscriptionId, consumer);
                } else {
                    consumer.setSelector(selector);
                }
                this.channel.addSubscription(destination, topic, subscriptionId, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unsubscribe(CommandMessage message) throws Exception {
            String subscriptionId = (String)message.getHeader("DSDstClientId");
            Map<String, JMSConsumer> map = this.consumers;
            synchronized (map) {
                JMSConsumer consumer = this.consumers.get(subscriptionId);
                try {
                    if (consumer != null) {
                        consumer.close();
                    }
                }
                finally {
                    this.consumers.remove(subscriptionId);
                    this.channel.removeSubscription(subscriptionId);
                }
            }
        }

        private class JMSConsumer
        implements MessageListener {
            private String subscriptionId = null;
            private Session jmsConsumerSession = null;
            private MessageConsumer jmsConsumer = null;
            private boolean noLocal = false;
            private boolean useJBossTCCLDeserializationWorkaround = false;
            private boolean useGlassFishNoCommitWorkaround = false;

            public JMSConsumer(String subscriptionId, String selector, boolean noLocal) throws Exception {
                this.subscriptionId = subscriptionId;
                this.noLocal = noLocal;
                this.jmsConsumerSession = JMSClientImpl.this.jmsConnection.createSession(((JMSClientImpl)JMSClientImpl.this).JMSServiceAdapter.this.transactedSessions, ((JMSClientImpl)JMSClientImpl.this).JMSServiceAdapter.this.acknowledgeMode);
                log.debug("Created JMS Consumer Session for channel %s (transacted: %s, ack: %s)", JMSClientImpl.this.channel.getId(), ((JMSClientImpl)JMSClientImpl.this).JMSServiceAdapter.this.transactedSessions, ((JMSClientImpl)JMSClientImpl.this).JMSServiceAdapter.this.acknowledgeMode);
                try {
                    int retryCount = ((JMSClientImpl)JMSClientImpl.this).JMSServiceAdapter.this.failoverRetryCount;
                    while (true) {
                        try {
                            this.jmsConsumer = this.jmsConsumerSession.createConsumer(JMSServiceAdapter.this.getConsumerDestination(JMSClientImpl.this.topic), selector, noLocal);
                        }
                        catch (Exception e) {
                            if (retryCount <= 0) {
                                throw e;
                            }
                            if (log.isDebugEnabled()) {
                                log.debug(e, "Could not create JMS Consumer (retrying %d time)", retryCount);
                            } else {
                                log.info("Could not create JMS Consumer (retrying %d time)", retryCount);
                            }
                            try {
                                Thread.sleep(((JMSClientImpl)JMSClientImpl.this).JMSServiceAdapter.this.failoverRetryInterval);
                                continue;
                            }
                            catch (Exception f) {
                                throw new ServiceException("Could not sleep when retrying to create JMS Consumer", f.getMessage(), e);
                            }
                            if (retryCount-- > 0) continue;
                        }
                        break;
                    }
                    this.jmsConsumer.setMessageListener((MessageListener)this);
                    log.debug("Created JMS Consumer for channel %s", JMSClientImpl.this.channel.getId());
                }
                catch (Exception e) {
                    this.close();
                    throw e;
                }
            }

            public void setSelector(String selector) throws JMSException {
                if (this.jmsConsumer != null) {
                    this.jmsConsumer.close();
                    this.jmsConsumer = null;
                }
                this.jmsConsumer = this.jmsConsumerSession.createConsumer(JMSServiceAdapter.this.getConsumerDestination(JMSClientImpl.this.topic), selector, this.noLocal);
                this.jmsConsumer.setMessageListener((MessageListener)this);
                log.debug("Changed selector to %s for JMS Consumer of channel %s", selector, JMSClientImpl.this.channel.getId());
            }

            public void close() throws JMSException {
                try {
                    if (this.jmsConsumer != null) {
                        this.jmsConsumer.close();
                        this.jmsConsumer = null;
                    }
                }
                finally {
                    if (this.jmsConsumerSession != null) {
                        this.jmsConsumerSession.close();
                        this.jmsConsumerSession = null;
                    }
                }
            }

            public void onMessage(javax.jms.Message message) {
                if (!(message instanceof ObjectMessage) && !(message instanceof TextMessage)) {
                    log.error("JMS Adapter message type not allowed: %s", message.getClass().getName());
                    try {
                        if (((JMSClientImpl)JMSClientImpl.this).JMSServiceAdapter.this.acknowledgeMode == 2) {
                            message.acknowledge();
                        }
                        if (((JMSClientImpl)JMSClientImpl.this).JMSServiceAdapter.this.transactedSessions) {
                            this.jmsConsumerSession.commit();
                        }
                    }
                    catch (JMSException e) {
                        log.error(e, "Could not ack/commit JMS onMessage", new Object[0]);
                    }
                }
                log.debug("Delivering JMS message to channel %s subscription %s", JMSClientImpl.this.channel.getId(), this.subscriptionId);
                AsyncMessage dmsg = new AsyncMessage();
                try {
                    TextMessage jmsMessage;
                    Object msg = null;
                    if (((JMSClientImpl)JMSClientImpl.this).JMSServiceAdapter.this.textMessages) {
                        jmsMessage = (TextMessage)message;
                        msg = jmsMessage.getText();
                    } else {
                        jmsMessage = (ObjectMessage)message;
                        if (this.useJBossTCCLDeserializationWorkaround) {
                            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                            try {
                                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                                msg = jmsMessage.getObject();
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(contextClassLoader);
                            }
                        }
                        try {
                            msg = jmsMessage.getObject();
                        }
                        catch (JMSException e) {
                            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                            try {
                                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                                msg = jmsMessage.getObject();
                                this.useJBossTCCLDeserializationWorkaround = true;
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(contextClassLoader);
                            }
                        }
                    }
                    dmsg.setDestination(JMSServiceAdapter.this.getDestination().getId());
                    if (Boolean.TRUE.equals(message.getBooleanProperty("GDS_BYTEARRAY_BODY"))) {
                        JMSServiceAdapter.this.getGravity().initThread();
                        try {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream(100);
                            AMF3Serializer ser = new AMF3Serializer(baos, false);
                            ser.writeObject(msg);
                            ser.close();
                            baos.close();
                            dmsg.setBody(baos.toByteArray());
                        }
                        finally {
                            JMSServiceAdapter.this.getGravity().releaseThread();
                        }
                    } else {
                        dmsg.setBody(msg);
                    }
                    dmsg.setMessageId(this.denormalizeJMSMessageID(message.getJMSMessageID()));
                    dmsg.setCorrelationId(this.denormalizeJMSMessageID(message.getJMSCorrelationID()));
                    dmsg.setTimestamp(message.getJMSTimestamp());
                    dmsg.setTimeToLive(message.getJMSExpiration());
                    Enumeration ename = message.getPropertyNames();
                    while (ename.hasMoreElements()) {
                        String pname = (String)ename.nextElement();
                        dmsg.setHeader(pname, message.getObjectProperty(pname));
                    }
                    dmsg.setHeader("JMSType", message.getJMSType());
                    dmsg.setHeader("JMSPriority", message.getJMSPriority());
                    dmsg.setHeader("JMSRedelivered", message.getJMSRedelivered());
                    dmsg.setHeader("JMSDeliveryMode", message.getJMSDeliveryMode());
                    dmsg.setHeader("DSDstClientId", this.subscriptionId);
                    JMSClientImpl.this.channel.receive(dmsg);
                }
                catch (IOException e) {
                    if (((JMSClientImpl)JMSClientImpl.this).JMSServiceAdapter.this.transactedSessions) {
                        try {
                            this.jmsConsumerSession.rollback();
                        }
                        catch (JMSException f) {
                            log.error("Could not rollback JMS session, messageId: %s", dmsg.getMessageId());
                        }
                    }
                    throw new RuntimeException("IO Error", e);
                }
                catch (JMSException e) {
                    if (((JMSClientImpl)JMSClientImpl.this).JMSServiceAdapter.this.transactedSessions) {
                        try {
                            this.jmsConsumerSession.rollback();
                        }
                        catch (JMSException f) {
                            log.error("Could not rollback JMS session, messageId: %s", dmsg.getMessageId());
                        }
                    }
                    throw new RuntimeException("JMS Error", e);
                }
                catch (MessageReceivingException e) {
                    if (((JMSClientImpl)JMSClientImpl.this).JMSServiceAdapter.this.transactedSessions) {
                        try {
                            this.jmsConsumerSession.rollback();
                        }
                        catch (JMSException f) {
                            log.error("Could not rollback JMS session, messageId: %s", dmsg.getMessageId());
                        }
                    }
                    throw new RuntimeException("Channel delivery Error", e);
                }
                try {
                    if (((JMSClientImpl)JMSClientImpl.this).JMSServiceAdapter.this.acknowledgeMode == 2) {
                        message.acknowledge();
                    }
                    if (((JMSClientImpl)JMSClientImpl.this).JMSServiceAdapter.this.transactedSessions && !this.useGlassFishNoCommitWorkaround) {
                        this.jmsConsumerSession.commit();
                    }
                }
                catch (JMSException e) {
                    if (e.getMessage() != null && e.getMessage().startsWith("MQJMSRA_DS4001")) {
                        this.useGlassFishNoCommitWorkaround = true;
                    }
                    log.error(e, "Could not ack/commit JMS onMessage, messageId: %s", dmsg.getMessageId());
                }
            }

            private String denormalizeJMSMessageID(String messageId) {
                if (messageId != null && messageId.startsWith("ID:")) {
                    messageId = messageId.substring(3);
                }
                return messageId;
            }
        }
    }
}

