/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service;

import flex.messaging.messages.RemotingMessage;
import java.util.HashMap;
import java.util.Map;
import org.granite.config.flex.Destination;
import org.granite.logging.Logger;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceInvoker;
import org.granite.messaging.service.SimpleServiceFactory;
import org.granite.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleServiceInvoker
extends ServiceInvoker<SimpleServiceFactory> {
    private static final Logger log = Logger.getLogger(SimpleServiceInvoker.class);
    private final Map<String, Object> sources;

    protected SimpleServiceInvoker(Destination destination, SimpleServiceFactory factory) throws ServiceException {
        super(destination, factory);
        String className = destination.getProperties().get("source");
        if (className == null) {
            throw new ServiceException("No source property for destination: " + destination);
        }
        className = className.trim();
        log.debug(">> New SimpleServiceInvoker constructing new: %s", className);
        if ("*".equals(className)) {
            this.sources = new HashMap<String, Object>();
        } else {
            try {
                this.invokee = destination.getScannedClass() != null ? destination.getScannedClass().newInstance() : ClassUtil.newInstance(className);
            }
            catch (Exception e) {
                throw new ServiceException("Invalid source property for destination: " + destination, e);
            }
            this.sources = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object adjustInvokee(RemotingMessage request, String methodName, Object[] args) throws ServiceException {
        if (this.sources == null) {
            return super.adjustInvokee(request, methodName, args);
        }
        String className = request.getSource();
        if (className == null) {
            throw new ServiceException("No source property in request for '*' destination: " + this.destination);
        }
        className = className.trim();
        Object invokee = null;
        Map<String, Object> map = this.sources;
        synchronized (map) {
            invokee = this.sources.get(className);
            if (invokee == null) {
                try {
                    invokee = ClassUtil.newInstance(className);
                }
                catch (Exception e) {
                    throw new ServiceException("Invalid source property in request for '*' destination: " + this.destination, e);
                }
                this.sources.put(className, invokee);
            }
        }
        return invokee;
    }
}

