/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.webapp;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.granite.clustering.TransientReference;
import org.granite.clustering.TransientReferenceHolder;
import org.granite.messaging.webapp.BaseContextMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SessionMap
extends BaseContextMap<String, Object> {
    private HttpServletRequest request = null;

    SessionMap(HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request is null");
        }
        this.request = request;
    }

    @Override
    public Object get(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        Object value = this.getSession().getAttribute(key.toString());
        if (value instanceof TransientReferenceHolder) {
            return ((TransientReferenceHolder)value).get();
        }
        return value;
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("Key should be a non null String: " + key);
        }
        HttpSession session = this.getSession();
        Object result = session.getAttribute(key);
        if (result instanceof TransientReferenceHolder) {
            result = ((TransientReferenceHolder)result).get();
        }
        if (value != null && value.getClass().isAnnotationPresent(TransientReference.class)) {
            value = new TransientReferenceHolder(value);
        }
        session.setAttribute(key, value);
        return result;
    }

    @Override
    public Object remove(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        HttpSession session = this.getSession();
        Object result = session.getAttribute(key.toString());
        if (result instanceof TransientReferenceHolder) {
            result = ((TransientReferenceHolder)result).get();
        }
        session.removeAttribute(key.toString());
        return result;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> entries = new HashSet<Map.Entry<String, Object>>();
        HttpSession session = this.getSession();
        Enumeration e = session.getAttributeNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object value = session.getAttribute(key);
            if (value instanceof TransientReferenceHolder) {
                value = ((TransientReferenceHolder)value).get();
            }
            entries.add(new BaseContextMap.Entry<String, Object>(key, value));
        }
        return entries;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SessionMap)) {
            return false;
        }
        return super.equals(obj);
    }

    private HttpSession getSession() {
        return this.request.getSession(true);
    }
}

