/*
 * Decompiled with CFR 0.152.
 */
package org.granite.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.granite.logging.Logger;
import org.granite.util.DOM;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMap
implements Serializable {
    private static final Logger log = Logger.getLogger(XMap.class);
    private static final long serialVersionUID = 1L;
    protected static final String DEFAULT_ROOT_NAME = "root";
    public static final XMap EMPTY_XMAP = new XMap(null, null, false){
        private static final long serialVersionUID = 1L;

        public String put(String key, String value) {
            throw new RuntimeException("Immutable XMap");
        }

        public String remove(String key) {
            throw new RuntimeException("Immutable XMap");
        }
    };
    private transient DOM dom = null;
    private transient Element root = null;

    public XMap() {
        this(null, null, false);
    }

    public XMap(String root) {
        if (root != null) {
            this.dom = new DOM();
            this.root = this.dom.newDocument(root).getDocumentElement();
        }
    }

    public XMap(InputStream input) throws IOException, SAXException {
        this.dom = new DOM();
        this.root = this.dom.loadDocument(input).getDocumentElement();
    }

    public XMap(InputStream input, EntityResolver resolver) throws IOException, SAXException {
        this.dom = new DOM();
        this.root = this.dom.loadDocument(input, resolver).getDocumentElement();
    }

    public XMap(Element root) {
        this(null, root, true);
    }

    public XMap(XMap map) {
        this(map == null ? null : map.dom, map == null ? null : map.root, true);
    }

    protected XMap(DOM dom, Element root, boolean clone) {
        this.dom = dom;
        this.root = clone && root != null ? (Element)root.cloneNode(true) : root;
    }

    public Element getRoot() {
        return this.root;
    }

    protected DOM getDom() {
        if (this.dom == null) {
            this.dom = new DOM();
        }
        return this.dom;
    }

    public boolean containsKey(String key) {
        if (this.root == null) {
            return false;
        }
        try {
            Node result = this.getDom().selectSingleNode(this.root, key);
            return result != null && (result.getNodeType() == 1 || result.getNodeType() == 3 || result.getNodeType() == 2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String get(String key) {
        if (this.root == null) {
            return null;
        }
        try {
            return this.getDom().getNormalizedValue(this.getDom().selectSingleNode(this.root, key));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T get(String key, Class<T> clazz, T defaultValue) {
        return this.get(key, clazz, defaultValue, false, true);
    }

    public <T> T get(String key, Class<T> clazz, T defaultValue, boolean required, boolean warn) {
        boolean unsupported;
        Object oValue;
        block22: {
            String sValue = this.get(key);
            if (required && sValue == null) {
                throw new RuntimeException(String.valueOf(key) + " value is required in XML file:\n" + this.toString());
            }
            oValue = defaultValue;
            unsupported = false;
            if (sValue != null) {
                try {
                    if (clazz == String.class) {
                        oValue = sValue;
                    } else if (clazz == Integer.class || clazz == Integer.TYPE) {
                        oValue = Integer.valueOf(sValue);
                    } else if (clazz == Long.class || clazz == Long.TYPE) {
                        oValue = Long.valueOf(sValue);
                    } else if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                        if (!Boolean.TRUE.toString().equalsIgnoreCase(sValue) && !Boolean.FALSE.toString().equalsIgnoreCase(sValue)) {
                            throw new NumberFormatException(sValue);
                        }
                        oValue = Boolean.valueOf(sValue);
                    } else if (clazz == Double.class || clazz == Double.TYPE) {
                        oValue = Double.valueOf(sValue);
                    } else if (clazz == Float.class || clazz == Float.TYPE) {
                        oValue = Float.valueOf(sValue);
                    } else if (clazz == Short.class || clazz == Short.TYPE) {
                        oValue = Short.valueOf(sValue);
                    } else if (clazz == Byte.class || clazz == Byte.TYPE) {
                        oValue = Byte.valueOf(sValue);
                    } else {
                        unsupported = true;
                    }
                }
                catch (Exception e) {
                    if (!warn) break block22;
                    log.warn(e, "Illegal %s value for %s=%s (using default: %s)", clazz.getSimpleName(), key, sValue, defaultValue);
                }
            }
        }
        if (unsupported) {
            throw new UnsupportedOperationException("Unsupported value type: " + clazz.getName());
        }
        T tValue = oValue;
        return tValue;
    }

    public List<XMap> getAll(String key) {
        if (this.root == null) {
            return new ArrayList<XMap>(0);
        }
        try {
            List<Node> result = this.dom.selectNodes(this.root, key);
            ArrayList<XMap> xMaps = new ArrayList<XMap>(result.size());
            for (Node node : result) {
                if (node.getNodeType() != 1) continue;
                xMaps.add(new XMap(this.dom, (Element)node, false));
            }
            return xMaps;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public XMap getOne(String key) {
        Node node;
        block4: {
            if (this.root == null) {
                return null;
            }
            try {
                node = this.getDom().selectSingleNode(this.root, key);
                if (node != null && node.getNodeType() == 1) break block4;
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new XMap(this.getDom(), (Element)node, false);
    }

    public String put(String key, String value) {
        return this.put(key, value, false);
    }

    public String put(String key, String value, boolean append) {
        if (this.root == null) {
            this.root = this.getDom().newDocument(DEFAULT_ROOT_NAME).getDocumentElement();
        }
        if (!append) {
            try {
                Node selectResult = this.getDom().selectSingleNode(this.root, key);
                if (selectResult != null) {
                    return this.getDom().setValue(selectResult, value);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Element parent = this.root;
        String name = key;
        int iLastSlash = key.lastIndexOf(47);
        if (iLastSlash != -1) {
            name = key.substring(iLastSlash + 1);
            Node selectResult = null;
            try {
                selectResult = this.getDom().selectSingleNode(this.root, key.substring(0, iLastSlash));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (selectResult == null) {
                throw new RuntimeException("Parent node does not exist: " + key.substring(0, iLastSlash));
            }
            if (!(selectResult instanceof Element)) {
                throw new RuntimeException("Parent node must be an Element: " + key.substring(0, iLastSlash) + " -> " + selectResult);
            }
            parent = (Element)selectResult;
        }
        if (name.length() > 0 && name.charAt(0) == '@') {
            parent.setAttribute(name.substring(1), value);
        } else {
            this.getDom().newElement(parent, name, value);
        }
        return null;
    }

    public String remove(String key) {
        if (this.root == null) {
            return null;
        }
        try {
            Node node = this.getDom().selectSingleNode(this.root, key);
            if (node != null) {
                String value = this.getDom().getNormalizedValue(node);
                if (node.getNodeType() == 2) {
                    ((Attr)node).getOwnerElement().removeAttribute(node.getNodeName());
                } else {
                    node.getParentNode().removeChild(node);
                }
                return value;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public String toString() {
        return this.getDom().toString(this.root);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.root == null) {
            out.writeInt(0);
        } else {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                this.getDom().saveDocument(this.root.getOwnerDocument(), output);
            }
            catch (TransformerException e) {
                IOException ioe = new IOException("Could not serialize this XMap");
                ioe.initCause(e);
                throw ioe;
            }
            out.writeInt(output.size());
            out.write(output.toByteArray());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        if (size > 0) {
            byte[] content = new byte[size];
            in.readFully(content);
            Document doc = null;
            try {
                doc = this.getDom().loadDocument(new ByteArrayInputStream(content));
            }
            catch (Exception e) {
                IOException ioe = new IOException("Could not deserialize this XMap");
                ioe.initCause(e);
                throw ioe;
            }
            if (doc != null && doc.getDocumentElement() != null) {
                this.root = doc.getDocumentElement();
            }
        }
    }
}

