/*
 * Decompiled with CFR 0.152.
 */
package org.granite.context;

import java.util.Map;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.ServicesConfig;
import org.granite.context.AMFContext;
import org.granite.context.AMFContextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraniteContext {
    private static ThreadLocal<GraniteContext> instance = new ThreadLocal<GraniteContext>(){

        @Override
        protected GraniteContext initialValue() {
            return null;
        }
    };
    private final GraniteConfig graniteConfig;
    private final ServicesConfig servicesConfig;
    private final AMFContext amfContext;
    private final String sessionId;

    public GraniteContext(GraniteConfig graniteConfig, ServicesConfig servicesConfig, String sessionId) {
        this.servicesConfig = servicesConfig;
        this.graniteConfig = graniteConfig;
        this.amfContext = new AMFContextImpl();
        this.sessionId = sessionId;
    }

    public static GraniteContext getCurrentInstance() {
        return instance.get();
    }

    protected static void setCurrentInstance(GraniteContext context) {
        instance.set(context);
    }

    public static void release() {
        instance.set(null);
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public GraniteConfig getGraniteConfig() {
        return this.graniteConfig;
    }

    public AMFContext getAMFContext() {
        return this.amfContext;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public abstract Object getSessionLock();

    public abstract Map<String, String> getInitialisationMap();

    public abstract Map<String, Object> getApplicationMap();

    public abstract Map<String, Object> getSessionMap();

    public abstract Map<String, Object> getSessionMap(boolean var1);

    public abstract Map<String, Object> getRequestMap();
}

