/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity;

import java.util.concurrent.atomic.AtomicBoolean;
import org.granite.gravity.Channel;
import org.granite.gravity.Gravity;

public abstract class AsyncChannelRunner
implements Runnable {
    protected final Channel channel;
    private final AtomicBoolean queued = new AtomicBoolean(false);

    public AsyncChannelRunner(Channel channel) {
        this.channel = channel;
    }

    public final boolean queue(Gravity gravity) {
        if (this.queued.getAndSet(true)) {
            return false;
        }
        gravity.execute(this);
        return true;
    }

    public final void reset() {
        this.queued.set(false);
    }

    protected abstract void doRun();

    public final void run() {
        try {
            this.doRun();
        }
        finally {
            this.queued.set(false);
        }
    }

    public boolean equals(Object obj) {
        return this.getClass().isInstance(obj) && this.channel.equals(((AsyncChannelRunner)obj).channel);
    }

    public int hashCode() {
        return this.channel.hashCode();
    }
}

