/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.granite.config.GraniteConfig;
import org.granite.config.GraniteConfigListener;
import org.granite.config.ServletGraniteConfig;
import org.granite.config.flex.ServicesConfig;
import org.granite.config.flex.ServletServicesConfig;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityConfig;
import org.granite.gravity.GravityFactory;
import org.granite.gravity.config.AbstractActiveMQTopicDestination;
import org.granite.gravity.config.AbstractJmsTopicDestination;
import org.granite.gravity.config.AbstractMessagingDestination;
import org.granite.gravity.config.servlet3.ActiveMQTopicDestination;
import org.granite.gravity.config.servlet3.JmsTopicDestination;
import org.granite.gravity.config.servlet3.MessagingDestination;
import org.granite.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GravityManager {
    private static final String GRAVITY_KEY = Gravity.class.getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Gravity start(ServletConfig servletConfig) throws ServletException {
        ServletContext context;
        Gravity gravity = null;
        ServletContext servletContext = context = servletConfig.getServletContext();
        synchronized (servletContext) {
            gravity = (Gravity)context.getAttribute(GRAVITY_KEY);
            if (gravity == null) {
                GraniteConfig graniteConfig = ServletGraniteConfig.loadConfig(context);
                ServicesConfig servicesConfig = ServletServicesConfig.loadConfig(context);
                Class flexFilterClass = (Class)context.getAttribute("org.granite.config.flexFilter");
                if (flexFilterClass != null) {
                    GravityManager.configureServices(context, flexFilterClass);
                }
                GravityConfig gravityConfig = new GravityConfig(graniteConfig);
                String gravityFactory = gravityConfig.getGravityFactory();
                try {
                    GravityFactory factory = TypeUtil.newInstance(gravityFactory, GravityFactory.class);
                    gravity = factory.newGravity(gravityConfig, servicesConfig, graniteConfig);
                }
                catch (Exception e) {
                    throw new ServletException("Could not create Gravity instance with factory: " + gravityFactory, (Throwable)e);
                }
                try {
                    gravity.start();
                    context.setAttribute(GRAVITY_KEY, (Object)gravity);
                    GraniteConfigListener.registerShutdownListener(context, gravity);
                }
                catch (Exception e) {
                    throw new ServletException("Gravity initialization error", (Throwable)e);
                }
            }
        }
        return gravity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reconfigure(ServletContext context, GravityConfig gravityConfig) {
        ServletContext servletContext = context;
        synchronized (servletContext) {
            Gravity gravity = GravityManager.getGravity(context);
            gravity.reconfigure(gravityConfig, ServletGraniteConfig.getConfig(context));
        }
    }

    public static Gravity getGravity(ServletContext context) {
        return (Gravity)context.getAttribute(GRAVITY_KEY);
    }

    private static void configureServices(ServletContext context, Class<?> flexFilterClass) throws ServletException {
        ServicesConfig servicesConfig = ServletServicesConfig.loadConfig(context);
        Field[] fieldArray = flexFilterClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractMessagingDestination messagingDestination;
            Annotation md;
            Field field = fieldArray[n2];
            if (field.isAnnotationPresent(MessagingDestination.class)) {
                md = field.getAnnotation(MessagingDestination.class);
                messagingDestination = new AbstractMessagingDestination();
                messagingDestination.setId(field.getName());
                messagingDestination.setNoLocal(md.noLocal());
                messagingDestination.setSessionSelector(md.sessionSelector());
                messagingDestination.initServices(servicesConfig);
            } else if (field.isAnnotationPresent(JmsTopicDestination.class)) {
                md = field.getAnnotation(JmsTopicDestination.class);
                messagingDestination = new AbstractJmsTopicDestination();
                messagingDestination.setId(field.getName());
                messagingDestination.setNoLocal(md.noLocal());
                messagingDestination.setSessionSelector(md.sessionSelector());
                ((AbstractJmsTopicDestination)messagingDestination).setName(md.name());
                ((AbstractJmsTopicDestination)messagingDestination).setAcknowledgeMode(md.acknowledgeMode());
                ((AbstractJmsTopicDestination)messagingDestination).setConnectionFactory(md.connectionFactory());
                ((AbstractJmsTopicDestination)messagingDestination).setTransactedSessions(md.transactedSessions());
                ((AbstractJmsTopicDestination)messagingDestination).setJndiName(md.topicJndiName());
                messagingDestination.initServices(servicesConfig);
            } else if (field.isAnnotationPresent(ActiveMQTopicDestination.class)) {
                md = field.getAnnotation(ActiveMQTopicDestination.class);
                messagingDestination = new AbstractActiveMQTopicDestination();
                messagingDestination.setId(field.getName());
                messagingDestination.setNoLocal(md.noLocal());
                messagingDestination.setSessionSelector(md.sessionSelector());
                ((AbstractJmsTopicDestination)messagingDestination).setName(md.name());
                ((AbstractJmsTopicDestination)messagingDestination).setAcknowledgeMode(md.acknowledgeMode());
                ((AbstractJmsTopicDestination)messagingDestination).setConnectionFactory(md.connectionFactory());
                ((AbstractJmsTopicDestination)messagingDestination).setTransactedSessions(md.transactedSessions());
                ((AbstractJmsTopicDestination)messagingDestination).setJndiName(md.topicJndiName());
                ((AbstractActiveMQTopicDestination)messagingDestination).setBrokerUrl(md.brokerUrl());
                ((AbstractActiveMQTopicDestination)messagingDestination).setCreateBroker(md.createBroker());
                ((AbstractActiveMQTopicDestination)messagingDestination).setDurable(md.durable());
                ((AbstractActiveMQTopicDestination)messagingDestination).setWaitForStart(md.waitForStart());
                ((AbstractActiveMQTopicDestination)messagingDestination).setFileStoreRoot(md.fileStoreRoot());
                messagingDestination.initServices(servicesConfig);
            }
            ++n2;
        }
    }
}

