/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.glassfish;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketApplication;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.granite.context.GraniteContext;
import org.granite.gravity.Gravity;
import org.granite.gravity.glassfish.GlassFishWebSocketChannel;
import org.granite.gravity.glassfish.GlassFishWebSocketChannelFactory;
import org.granite.logging.Logger;
import org.granite.messaging.webapp.ServletGraniteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassFishWebSocketApplication
extends WebSocketApplication {
    private static final Logger log = Logger.getLogger(GlassFishWebSocketApplication.class);
    private final ServletContext servletContext;
    private final Gravity gravity;
    private final Pattern mapping;

    public GlassFishWebSocketApplication(ServletContext servletContext, Gravity gravity, String mapping) {
        this.servletContext = servletContext;
        this.gravity = gravity;
        this.mapping = Pattern.compile(".*" + mapping.replace("*", ".*") + "$");
    }

    public List<String> getSupportedProtocols(List<String> subProtocol) {
        if (subProtocol.contains("org.granite.gravity")) {
            return Collections.singletonList("org.granite.gravity");
        }
        return Collections.emptyList();
    }

    public boolean isApplicationRequest(Request request) {
        String uri = request.requestURI().toString();
        if (!this.mapping.matcher(uri).matches()) {
            return false;
        }
        request.getParameters().handleQueryParameters();
        String connectMessageId = request.getHeader("connectId");
        if (connectMessageId == null && request.getParameters().getParameter("connectId") != null) {
            connectMessageId = request.getParameters().getParameter("connectId");
        }
        String clientId = request.getHeader("GDSClientId") != null ? request.getHeader("GDSClientId") : request.getParameters().getParameter("GDSClientId");
        String sessionId = null;
        if (request.getHeader("GDSSessionId") != null) {
            sessionId = request.getHeader("GDSSessionId");
        }
        if (sessionId == null && request.getParameters().getParameter("GDSSessionId") != null) {
            sessionId = request.getParameters().getParameter("GDSSessionId");
        }
        ServletGraniteContext graniteContext = ServletGraniteContext.createThreadInstance(this.gravity.getGraniteConfig(), this.gravity.getServicesConfig(), this.servletContext, sessionId);
        if (connectMessageId != null) {
            graniteContext.getRequest().setAttribute("connectId", (Object)connectMessageId);
        }
        if (clientId != null) {
            graniteContext.getRequest().setAttribute("clientId", (Object)clientId);
        }
        return true;
    }

    public void onConnect(WebSocket websocket) {
        GlassFishWebSocketChannelFactory channelFactory = new GlassFishWebSocketChannelFactory(this.gravity);
        try {
            log.info("WebSocket connection", new Object[0]);
            ServletGraniteContext graniteContext = (ServletGraniteContext)GraniteContext.getCurrentInstance();
            String connectMessageId = (String)graniteContext.getRequest().getAttribute("connectId");
            String clientId = (String)graniteContext.getRequest().getAttribute("clientId");
            CommandMessage pingMessage = new CommandMessage();
            pingMessage.setMessageId(connectMessageId != null ? connectMessageId : "OPEN_CONNECTION");
            pingMessage.setOperation(5);
            if (clientId != null) {
                pingMessage.setClientId(clientId);
            }
            Message ackMessage = this.gravity.handleMessage(channelFactory, pingMessage);
            GlassFishWebSocketChannel channel = this.gravity.getChannel(channelFactory, (String)ackMessage.getClientId());
            if (!ackMessage.getClientId().equals(clientId)) {
                channel.setConnectAckMessage(ackMessage);
            }
            channel.setWebSocket(websocket);
        }
        finally {
            GraniteContext.release();
        }
    }
}

