/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.glassfish;

import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketListener;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.granite.context.GraniteContext;
import org.granite.context.SimpleGraniteContext;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.AsyncHttpContext;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityConfig;
import org.granite.gravity.glassfish.GlassFishWebSocketChannelFactory;
import org.granite.logging.Logger;

public class GlassFishWebSocketChannel
extends AbstractChannel
implements WebSocketListener {
    private static final Logger log = Logger.getLogger(GlassFishWebSocketChannel.class);
    private WebSocket websocket;
    private Message connectAckMessage;

    public GlassFishWebSocketChannel(Gravity gravity, String id, GlassFishWebSocketChannelFactory factory) {
        super(gravity, id, factory);
    }

    public void setConnectAckMessage(Message ackMessage) {
        this.connectAckMessage = ackMessage;
    }

    public void setWebSocket(WebSocket websocket) {
        this.websocket = websocket;
        this.websocket.add((WebSocketListener)this);
        if (this.connectAckMessage == null) {
            return;
        }
        try {
            byte[] resultData = GlassFishWebSocketChannel.serialize(this.getGravity(), new Message[]{this.connectAckMessage});
            websocket.send(resultData);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not send connect acknowledge", e);
        }
        this.connectAckMessage = null;
    }

    public void onConnect(WebSocket websocket) {
    }

    public void onClose(WebSocket websocket, DataFrame frame) {
    }

    public void onMessage(WebSocket websocket, byte[] data) {
        try {
            try {
                this.initializeRequest(this.getGravity());
                Message[] messages = GlassFishWebSocketChannel.deserialize(this.getGravity(), data);
                log.debug(">> [AMF3 REQUESTS] %s", new Object[]{messages});
                Message[] responses = null;
                boolean accessed = false;
                int i = 0;
                while (i < messages.length) {
                    Message message = messages[i];
                    Message response = this.getGravity().handleMessage(this.getFactory(), message);
                    String channelId = (String)message.getClientId();
                    if (!accessed) {
                        accessed = this.getGravity().access(channelId);
                    }
                    if (responses == null) {
                        responses = new Message[messages.length];
                    }
                    responses[i] = response;
                    ++i;
                }
                log.debug("<< [AMF3 RESPONSES] %s", new Object[]{responses});
                byte[] resultData = GlassFishWebSocketChannel.serialize(this.getGravity(), responses);
                websocket.send(resultData);
            }
            catch (ClassNotFoundException e) {
                log.error(e, "Could not handle incoming message data", new Object[0]);
                GlassFishWebSocketChannel.cleanupRequest();
            }
            catch (IOException e) {
                log.error(e, "Could not handle incoming message data", new Object[0]);
                GlassFishWebSocketChannel.cleanupRequest();
            }
        }
        finally {
            GlassFishWebSocketChannel.cleanupRequest();
        }
    }

    private Gravity initializeRequest(Gravity gravity) {
        SimpleGraniteContext.createThreadInstance(gravity.getGraniteConfig(), gravity.getServicesConfig(), this.sessionId, new HashMap<String, Object>());
        return gravity;
    }

    private static Message[] deserialize(Gravity gravity, byte[] data) throws ClassNotFoundException, IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        try {
            ObjectInput amf3Deserializer = gravity.getGraniteConfig().newAMF3Deserializer(is);
            Object[] objects = (Object[])amf3Deserializer.readObject();
            Message[] messages = new Message[objects.length];
            System.arraycopy(objects, 0, messages, 0, objects.length);
            Message[] messageArray = messages;
            return messageArray;
        }
        finally {
            is.close();
        }
    }

    private static byte[] serialize(Gravity gravity, Message[] messages) throws IOException {
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream(200 * messages.length);
            ObjectOutput amf3Serializer = gravity.getGraniteConfig().newAMF3Serializer(os);
            amf3Serializer.writeObject(messages);
            os.flush();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    private static void cleanupRequest() {
        GraniteContext.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean runReceived(AsyncHttpContext asyncHttpContext) {
        LinkedList messages = null;
        ByteArrayOutputStream os = null;
        try {
            this.receivedQueueLock.lock();
            try {
                if (this.receivedQueue.isEmpty()) {
                    return false;
                }
                messages = this.receivedQueue;
                this.receivedQueue = new LinkedList();
            }
            finally {
                this.receivedQueueLock.unlock();
            }
            if (this.websocket == null) return false;
            if (!this.websocket.isConnected()) {
                return false;
            }
            AsyncMessage[] messagesArray = new AsyncMessage[messages.size()];
            int i = 0;
            Iterator iterator = messages.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    Gravity gravity = this.getGravity();
                    SimpleGraniteContext context = SimpleGraniteContext.createThreadInstance(gravity.getGraniteConfig(), gravity.getServicesConfig(), this.sessionId, new HashMap<String, Object>());
                    os = new ByteArrayOutputStream(500);
                    ObjectOutput amf3Serializer = context.getGraniteConfig().newAMF3Serializer(os);
                    log.debug("<< [MESSAGES for channel=%s] %s", this, messagesArray);
                    amf3Serializer.writeObject(messagesArray);
                    this.websocket.send(os.toByteArray());
                    return true;
                }
                AsyncMessage message = (AsyncMessage)iterator.next();
                messagesArray[i++] = message;
            }
        }
        catch (IOException e) {
            log.warn(e, "Could not send messages to channel: %s (retrying later)", this);
            GravityConfig gravityConfig = this.getGravity().getGravityConfig();
            if (!gravityConfig.isRetryOnError()) return true;
            this.receivedQueueLock.lock();
            try {
                if (this.receivedQueue.size() + messages.size() > gravityConfig.getMaxMessagesQueuedPerChannel()) {
                    log.warn("Channel %s has reached its maximum queue capacity %s (throwing %s messages)", this, gravityConfig.getMaxMessagesQueuedPerChannel(), messages.size());
                    return true;
                }
                this.receivedQueue.addAll(0, messages);
                return true;
            }
            finally {
                this.receivedQueueLock.unlock();
            }
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
            try {
                GraniteContext.release();
            }
            catch (Exception exception) {}
        }
    }

    public void destroy() {
        try {
            super.destroy();
        }
        finally {
            this.close();
        }
    }

    public void close() {
        if (this.websocket != null) {
            this.websocket.close(1000, "Channel closed");
            this.websocket = null;
        }
    }

    protected boolean hasAsyncHttpContext() {
        return true;
    }

    protected void releaseAsyncHttpContext(AsyncHttpContext context) {
    }

    protected AsyncHttpContext acquireAsyncHttpContext() {
        return null;
    }

    public void onFragment(WebSocket arg0, String arg1, boolean arg2) {
    }

    public void onFragment(WebSocket arg0, byte[] arg1, boolean arg2) {
    }

    public void onMessage(WebSocket arg0, String arg1) {
    }

    public void onPing(WebSocket arg0, byte[] arg1) {
    }

    public void onPong(WebSocket arg0, byte[] arg1) {
    }
}

