/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.jetty8;

import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import org.eclipse.jetty.continuation.Continuation;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.AsyncHttpContext;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityConfig;
import org.granite.gravity.MessageReceivingException;
import org.granite.gravity.jetty8.ContinuationChannelFactory;
import org.granite.logging.Logger;

public class ContinuationChannel
extends AbstractChannel {
    private static final Logger log = Logger.getLogger(ContinuationChannel.class);
    private Continuation continuation = null;

    public ContinuationChannel(Gravity gravity, String id, ContinuationChannelFactory factory) {
        super(gravity, id, factory);
    }

    public void setContinuation(Continuation continuation) {
        log.debug("Setting continuation %s for client: %s", continuation, this.getId());
        try {
            if (this.continuation != null && this.continuation.isSuspended()) {
                log.debug("Resuming previous continuation %s for client: %s", this.continuation, this.getId());
                this.continuation.resume();
            }
        }
        finally {
            this.continuation = continuation;
        }
    }

    public void close() {
        this.continuation = null;
    }

    public void resume() {
        log.debug("Resuming pending continuation %s for client: %s", this.continuation, this.getId());
        try {
            if (this.continuation != null && this.continuation.isSuspended()) {
                this.continuation.resume();
            }
        }
        finally {
            this.continuation = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(AsyncMessage message) throws MessageReceivingException {
        if (message == null) {
            throw new NullPointerException("message cannot be null");
        }
        GravityConfig gravityConfig = this.gravity.getGravityConfig();
        this.receivedQueueLock.lock();
        try {
            if (this.receivedQueue.size() + 1 > gravityConfig.getMaxMessagesQueuedPerChannel()) {
                throw new MessageReceivingException((Message)message, "Could not queue message (channel's queue is full) for channel: " + this);
            }
            this.receivedQueue.add(message);
        }
        finally {
            this.receivedQueueLock.unlock();
        }
        ContinuationChannel continuationChannel = this;
        synchronized (continuationChannel) {
            this.resume();
        }
    }

    protected boolean hasAsyncHttpContext() {
        return false;
    }

    protected void releaseAsyncHttpContext(AsyncHttpContext context) {
    }

    protected AsyncHttpContext acquireAsyncHttpContext() {
        return null;
    }

    public boolean isLocal() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            super.destroy();
        }
        catch (Throwable throwable) {
            ContinuationChannel continuationChannel = this;
            synchronized (continuationChannel) {
                this.close();
            }
            throw throwable;
        }
        ContinuationChannel continuationChannel = this;
        synchronized (continuationChannel) {
            this.close();
        }
    }
}

