/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.servlet3;

import flex.messaging.messages.CommandMessage;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.AbstractGravityServlet;
import org.granite.gravity.AsyncHttpContext;
import org.granite.gravity.Gravity;
import org.granite.gravity.servlet3.AsyncChannelFactory;
import org.granite.logging.Logger;

public class AsyncChannel
extends AbstractChannel {
    private static final Logger log = Logger.getLogger(AsyncChannel.class);
    private final AtomicReference<AsyncContext> asyncContext = new AtomicReference();

    public AsyncChannel(Gravity gravity, String id, AsyncChannelFactory factory) {
        super(gravity, id, factory);
    }

    public void setAsyncContext(AsyncContext asyncContext) {
        AsyncContext previousAsyncContext;
        if (log.isDebugEnabled()) {
            log.debug("Channel: %s got new asyncContext: %s", this.getId(), asyncContext);
        }
        if ((previousAsyncContext = this.asyncContext.getAndSet(asyncContext)) != null) {
            if (asyncContext != null) {
                log.warn("Got a new non null asyncContext %s while current asyncContext %s isn't null", asyncContext, this.asyncContext.get());
            }
            if (previousAsyncContext != asyncContext) {
                try {
                    previousAsyncContext.complete();
                }
                catch (Exception e) {
                    log.debug(e, "Error while closing asyncContext", new Object[0]);
                }
            }
        }
        if (asyncContext != null) {
            this.queueReceiver();
        }
    }

    protected boolean hasAsyncHttpContext() {
        return this.asyncContext.get() != null;
    }

    protected AsyncHttpContext acquireAsyncHttpContext() {
        CommandMessage requestMessage;
        HttpServletResponse response;
        HttpServletRequest request;
        AsyncHttpContext context;
        AsyncContext asyncContext;
        block23: {
            block24: {
                block21: {
                    block22: {
                        asyncContext = this.asyncContext.getAndSet(null);
                        if (asyncContext == null) {
                            return null;
                        }
                        context = null;
                        try {
                            request = null;
                            response = null;
                            try {
                                request = (HttpServletRequest)asyncContext.getRequest();
                                response = (HttpServletResponse)asyncContext.getResponse();
                            }
                            catch (Exception e) {
                                log.warn("Illegal asyncContext: %s", asyncContext);
                                if (context == null) {
                                    try {
                                        asyncContext.complete();
                                    }
                                    catch (Exception e2) {
                                        log.debug(e2, "Error while closing asyncContext: %s", asyncContext);
                                    }
                                }
                                return null;
                            }
                        }
                        catch (Throwable throwable) {
                            if (context == null) {
                                try {
                                    asyncContext.complete();
                                }
                                catch (Exception e) {
                                    log.debug(e, "Error while closing asyncContext: %s", asyncContext);
                                }
                            }
                            throw throwable;
                        }
                        if (request != null && response != null) break block21;
                        log.warn("Illegal asyncContext (request or response is null): %s", asyncContext);
                        if (context != null) break block22;
                        try {
                            asyncContext.complete();
                        }
                        catch (Exception e) {
                            log.debug(e, "Error while closing asyncContext: %s", asyncContext);
                        }
                    }
                    return null;
                }
                requestMessage = AbstractGravityServlet.getConnectMessage(request);
                if (requestMessage != null) break block23;
                log.warn("No request message while running channel: %s", this.getId());
                if (context != null) break block24;
                try {
                    asyncContext.complete();
                }
                catch (Exception e) {
                    log.debug(e, "Error while closing asyncContext: %s", asyncContext);
                }
            }
            return null;
        }
        context = new AsyncHttpContext(request, response, requestMessage, asyncContext);
        if (context == null) {
            try {
                asyncContext.complete();
            }
            catch (Exception e) {
                log.debug(e, "Error while closing asyncContext: %s", asyncContext);
            }
        }
        return context;
    }

    protected void releaseAsyncHttpContext(AsyncHttpContext context) {
        try {
            if (context != null && context.getObject() != null) {
                ((AsyncContext)context.getObject()).complete();
            }
        }
        catch (Exception e) {
            log.warn(e, "Could not release asyncContext for channel: %s", this);
        }
    }

    public void destroy() {
        try {
            super.destroy();
        }
        finally {
            this.close();
        }
    }

    public void close() {
        AsyncContext asyncContext = this.asyncContext.getAndSet(null);
        if (asyncContext != null) {
            try {
                asyncContext.complete();
            }
            catch (Exception e) {
                log.debug(e, "Could not close asyncContext: %s for channel: %s", asyncContext, this);
            }
        }
    }
}

