/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.tomcat;

import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import javax.servlet.ServletContext;
import org.apache.catalina.websocket.MessageInbound;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.catalina.websocket.WsOutbound;
import org.granite.context.GraniteContext;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.AsyncHttpContext;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityConfig;
import org.granite.gravity.tomcat.TomcatWebSocketChannelFactory;
import org.granite.logging.Logger;
import org.granite.messaging.webapp.ServletGraniteContext;

public class TomcatWebSocketChannel
extends AbstractChannel {
    private static final Logger log = Logger.getLogger(TomcatWebSocketChannel.class);
    private StreamInbound streamInbound = new MessageInboundImpl();
    private ServletContext servletContext;
    private WsOutbound connection;
    private byte[] connectAckMessage;

    public TomcatWebSocketChannel(Gravity gravity, String id, TomcatWebSocketChannelFactory factory, ServletContext servletContext) {
        super(gravity, id, factory);
        this.servletContext = servletContext;
    }

    public void setConnectAckMessage(Message ackMessage) {
        try {
            this.connectAckMessage = TomcatWebSocketChannel.serialize(this.getGravity(), new Message[]{ackMessage});
        }
        catch (IOException e) {
            throw new RuntimeException("Could not send connect acknowledge", e);
        }
    }

    public StreamInbound getStreamInbound() {
        return this.streamInbound;
    }

    private Gravity initializeRequest() {
        ServletGraniteContext.createThreadInstance(this.gravity.getGraniteConfig(), this.gravity.getServicesConfig(), this.servletContext, this.sessionId);
        return this.gravity;
    }

    private static Message[] deserialize(Gravity gravity, byte[] data) throws ClassNotFoundException, IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        try {
            ObjectInput amf3Deserializer = gravity.getGraniteConfig().newAMF3Deserializer(is);
            Object[] objects = (Object[])amf3Deserializer.readObject();
            Message[] messages = new Message[objects.length];
            System.arraycopy(objects, 0, messages, 0, objects.length);
            Message[] messageArray = messages;
            return messageArray;
        }
        finally {
            is.close();
        }
    }

    private static byte[] serialize(Gravity gravity, Message[] messages) throws IOException {
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream(200 * messages.length);
            ObjectOutput amf3Serializer = gravity.getGraniteConfig().newAMF3Serializer(os);
            amf3Serializer.writeObject(messages);
            os.flush();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    private static void cleanupRequest() {
        GraniteContext.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean runReceived(AsyncHttpContext asyncHttpContext) {
        LinkedList messages = null;
        ByteArrayOutputStream os = null;
        try {
            this.receivedQueueLock.lock();
            try {
                if (this.receivedQueue.isEmpty()) {
                    return false;
                }
                messages = this.receivedQueue;
                this.receivedQueue = new LinkedList();
            }
            finally {
                this.receivedQueueLock.unlock();
            }
            if (this.connection == null) {
                return false;
            }
            AsyncMessage[] messagesArray = new AsyncMessage[messages.size()];
            int i = 0;
            Iterator iterator = messages.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    Gravity gravity = this.getGravity();
                    ServletGraniteContext context = ServletGraniteContext.createThreadInstance(gravity.getGraniteConfig(), gravity.getServicesConfig(), this.servletContext, this.sessionId);
                    os = new ByteArrayOutputStream(500);
                    ObjectOutput amf3Serializer = context.getGraniteConfig().newAMF3Serializer(os);
                    log.debug("<< [MESSAGES for channel=%s] %s", this, messagesArray);
                    amf3Serializer.writeObject(messagesArray);
                    this.connection.writeBinaryMessage(ByteBuffer.wrap(os.toByteArray()));
                    return true;
                }
                AsyncMessage message = (AsyncMessage)iterator.next();
                messagesArray[i++] = message;
            }
        }
        catch (IOException e) {
            log.warn(e, "Could not send messages to channel: %s (retrying later)", this);
            GravityConfig gravityConfig = this.getGravity().getGravityConfig();
            if (!gravityConfig.isRetryOnError()) return true;
            this.receivedQueueLock.lock();
            try {
                if (this.receivedQueue.size() + messages.size() > gravityConfig.getMaxMessagesQueuedPerChannel()) {
                    log.warn("Channel %s has reached its maximum queue capacity %s (throwing %s messages)", this, gravityConfig.getMaxMessagesQueuedPerChannel(), messages.size());
                    return true;
                }
                this.receivedQueue.addAll(0, messages);
                return true;
            }
            finally {
                this.receivedQueueLock.unlock();
            }
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
            try {
                GraniteContext.release();
            }
            catch (Exception exception) {}
        }
    }

    public void destroy() {
        try {
            super.destroy();
        }
        finally {
            this.close();
        }
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close(1000, ByteBuffer.wrap("Channel closed".getBytes()));
            }
            catch (IOException e) {
                log.error("Could not close WebSocket connection", e);
            }
            this.connection = null;
        }
    }

    protected boolean hasAsyncHttpContext() {
        return true;
    }

    protected void releaseAsyncHttpContext(AsyncHttpContext context) {
    }

    protected AsyncHttpContext acquireAsyncHttpContext() {
        return null;
    }

    public class MessageInboundImpl
    extends MessageInbound {
        protected void onOpen(WsOutbound outbound) {
            TomcatWebSocketChannel.this.connection = outbound;
            log.debug("WebSocket connection onOpen", new Object[0]);
            if (TomcatWebSocketChannel.this.connectAckMessage == null) {
                return;
            }
            try {
                ByteBuffer buf = ByteBuffer.wrap(TomcatWebSocketChannel.this.connectAckMessage);
                TomcatWebSocketChannel.this.connection.writeBinaryMessage(buf);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not send connect acknowledge", e);
            }
            TomcatWebSocketChannel.this.connectAckMessage = null;
        }

        public void onClose(int closeCode) {
            log.debug("WebSocket connection onClose %d", closeCode);
            TomcatWebSocketChannel.this.connection = null;
        }

        public void onBinaryMessage(ByteBuffer buf) {
            byte[] data = buf.array();
            log.debug("WebSocket connection onBinaryMessage %d", data.length);
            try {
                try {
                    TomcatWebSocketChannel.this.initializeRequest();
                    Message[] messages = TomcatWebSocketChannel.deserialize(TomcatWebSocketChannel.this.getGravity(), data);
                    log.debug(">> [AMF3 REQUESTS] %s", new Object[]{messages});
                    Message[] responses = null;
                    boolean accessed = false;
                    int responseIndex = 0;
                    int i = 0;
                    while (i < messages.length) {
                        Message message = messages[i];
                        Message response = TomcatWebSocketChannel.this.getGravity().handleMessage(TomcatWebSocketChannel.this.getFactory(), message);
                        String channelId = (String)message.getClientId();
                        if (!accessed) {
                            accessed = TomcatWebSocketChannel.this.getGravity().access(channelId);
                        }
                        if (response != null) {
                            responses = responses == null ? new Message[1] : Arrays.copyOf(responses, responses.length + 1);
                            responses[responseIndex++] = response;
                        }
                        ++i;
                    }
                    if (responses != null && responses.length > 0) {
                        log.debug("<< [AMF3 RESPONSES] %s", new Object[]{responses});
                        byte[] resultData = TomcatWebSocketChannel.serialize(TomcatWebSocketChannel.this.getGravity(), responses);
                        TomcatWebSocketChannel.this.connection.writeBinaryMessage(ByteBuffer.wrap(resultData));
                    }
                }
                catch (ClassNotFoundException e) {
                    log.error(e, "Could not handle incoming message data", new Object[0]);
                    TomcatWebSocketChannel.cleanupRequest();
                }
                catch (IOException e) {
                    log.error(e, "Could not handle incoming message data", new Object[0]);
                    TomcatWebSocketChannel.cleanupRequest();
                }
            }
            finally {
                TomcatWebSocketChannel.cleanupRequest();
            }
        }

        protected void onTextMessage(CharBuffer buf) throws IOException {
        }

        public int getAckLength() {
            return TomcatWebSocketChannel.this.connectAckMessage != null ? TomcatWebSocketChannel.this.connectAckMessage.length : 0;
        }
    }
}

