/*
 * Decompiled with CFR 0.152.
 */
package org.granite.logging;

import java.lang.reflect.Constructor;
import org.granite.logging.DefaultLoggingFormatter;
import org.granite.logging.JdkLogger;
import org.granite.logging.Level;
import org.granite.logging.Log4jLogger;
import org.granite.logging.LoggingFormatter;
import org.granite.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Logger {
    public static final String LOGGER_IMPL_SYSTEM_PROPERTY = "org.granite.logger.impl";
    private static final boolean log4jAvailable;
    private final Object loggerImpl;
    private final LoggingFormatter formatter;

    static {
        boolean available = false;
        try {
            TypeUtil.forName("org.apache.log4j.Logger");
            available = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        log4jAvailable = available;
    }

    protected Logger(Object loggerImpl, LoggingFormatter formatter) {
        this.loggerImpl = loggerImpl;
        this.formatter = formatter;
    }

    protected Object getLoggerImpl() {
        return this.loggerImpl;
    }

    protected LoggingFormatter getFormatter() {
        return this.formatter;
    }

    public static Logger getLogger() {
        return Logger.getLogger(new DefaultLoggingFormatter());
    }

    public static Logger getLogger(Class<?> clazz) {
        return Logger.getLogger(clazz.getName(), (LoggingFormatter)new DefaultLoggingFormatter());
    }

    public static Logger getLogger(String name) {
        return Logger.getLogger(name, (LoggingFormatter)new DefaultLoggingFormatter());
    }

    public static Logger getLogger(LoggingFormatter formatter) {
        Throwable t = new Throwable();
        StackTraceElement[] stes = t.getStackTrace();
        if (stes.length < 2) {
            throw new RuntimeException("Illegal instantiation context (stacktrace elements should be of length >= 2)", t);
        }
        return Logger.getLogger(stes[1].getClassName());
    }

    public static Logger getLogger(Class<?> clazz, LoggingFormatter formatter) {
        return Logger.getLogger(clazz.getName(), formatter);
    }

    public static Logger getLogger(String name, LoggingFormatter formatter) {
        String loggerImplClass = System.getProperty(LOGGER_IMPL_SYSTEM_PROPERTY);
        if (loggerImplClass != null) {
            try {
                Class<Logger> clazz = TypeUtil.forName(loggerImplClass, Logger.class);
                Constructor<Logger> constructor = clazz.getConstructor(String.class, LoggingFormatter.class);
                return constructor.newInstance(name, formatter);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create instance of: " + loggerImplClass + " (" + LOGGER_IMPL_SYSTEM_PROPERTY + " system property)", e);
            }
        }
        return log4jAvailable ? new Log4jLogger(name, formatter) : new JdkLogger(name, formatter);
    }

    public abstract void info(String var1, Object ... var2);

    public abstract void info(Throwable var1, String var2, Object ... var3);

    public abstract void trace(String var1, Object ... var2);

    public abstract void trace(Throwable var1, String var2, Object ... var3);

    public abstract void warn(String var1, Object ... var2);

    public abstract void warn(Throwable var1, String var2, Object ... var3);

    public abstract void debug(String var1, Object ... var2);

    public abstract void debug(Throwable var1, String var2, Object ... var3);

    public abstract void error(String var1, Object ... var2);

    public abstract void error(Throwable var1, String var2, Object ... var3);

    public abstract void fatal(String var1, Object ... var2);

    public abstract void fatal(Throwable var1, String var2, Object ... var3);

    public abstract void setLevel(Level var1);

    public abstract boolean isDebugEnabled();

    public abstract boolean isErrorEnabled();

    public abstract boolean isFatalEnabled();

    public abstract boolean isInfoEnabled();

    public abstract boolean isTraceEnabled();

    public abstract boolean isWarnEnabled();
}

