/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide;

import flex.messaging.messages.RemotingMessage;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.granite.config.flex.Destination;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceFactory;
import org.granite.messaging.service.ServiceInvocationContext;
import org.granite.messaging.service.ServiceInvoker;
import org.granite.messaging.service.security.SecurityServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.tide.IInvocationCall;
import org.granite.tide.IInvocationResult;
import org.granite.tide.TideServiceContext;
import org.granite.tide.data.DataContext;
import org.granite.tide.data.DataEnabled;
import org.granite.tide.data.DataMergeContext;
import org.granite.tide.validators.EntityValidator;
import org.granite.tide.validators.InvalidValue;
import org.granite.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TideServiceInvoker<T extends ServiceFactory>
extends ServiceInvoker<T> {
    private static final Logger log = Logger.getLogger(TideServiceInvoker.class);
    public static final String VALIDATOR_KEY = "org.granite.tide.validator.key";
    public static final String VALIDATOR_NOT_AVAILABLE = "org.granite.tide.validator.notAvailable";
    public static final String VALIDATOR_NAME = "validator-name";
    public static final String VALIDATOR_CLASS_NAME = "validator-class-name";
    private TideServiceContext tideContext = null;
    private transient EntityValidator validator = null;
    private static final InvalidValue[] EMPTY_INVALID_VALUES = new InvalidValue[0];
    private static final String DATAENABLED_HANDLED = "org.granite.tide.invoker.dataEnabled";

    public TideServiceInvoker(Destination destination, T factory) throws ServiceException {
        super(destination, factory);
        this.invokee = this;
        this.tideContext = this.lookupContext();
        this.tideContext.initCall();
        this.initValidator();
    }

    public TideServiceInvoker(Destination destination, T factory, TideServiceContext tideContext) throws ServiceException {
        super(destination, factory);
        this.invokee = this;
        this.tideContext = tideContext;
        this.tideContext.initCall();
        this.initValidator();
    }

    public Object initializeObject(Object parent, String[] propertyNames) {
        return this.tideContext.lazyInitialize(parent, propertyNames);
    }

    protected void initValidator() {
        Map<String, Object> applicationMap = GraniteContext.getCurrentInstance().getApplicationMap();
        Boolean validatorNotAvailable = (Boolean)applicationMap.get(VALIDATOR_NOT_AVAILABLE);
        this.validator = (EntityValidator)applicationMap.get(VALIDATOR_KEY);
        if (this.validator != null || Boolean.TRUE.equals(validatorNotAvailable)) {
            return;
        }
        String className = this.destination.getProperties().get(VALIDATOR_CLASS_NAME);
        if (className != null) {
            this.initValidatorWithClassName(className, null);
            if (this.validator == null) {
                log.warn("Validator class " + className + " not found: validation not enabled", new Object[0]);
                applicationMap.put(VALIDATOR_NOT_AVAILABLE, Boolean.TRUE);
            } else {
                log.info("Validator class " + className + " initialized", new Object[0]);
                applicationMap.put(VALIDATOR_KEY, this.validator);
            }
        } else {
            String name = this.destination.getProperties().get(VALIDATOR_NAME);
            if (name != null) {
                try {
                    this.validator = (EntityValidator)this.tideContext.findComponent(name, EntityValidator.class);
                }
                catch (ServiceException e) {
                    name = null;
                }
            }
            if (this.validator == null) {
                className = "org.granite.tide.validation.BeanValidation";
                this.initValidatorWithClassName(className, "javax.validation.ValidatorFactory");
            }
            if (this.validator == null) {
                if (name != null) {
                    log.warn("Validator component " + name + " not found: validation not enabled", new Object[0]);
                } else {
                    log.warn("Validator class " + className + " not found: validation not enabled", new Object[0]);
                }
                applicationMap.put(VALIDATOR_NOT_AVAILABLE, Boolean.TRUE);
            } else {
                log.info("Validator class " + this.validator.getClass().getName() + " initialized", new Object[0]);
                applicationMap.put(VALIDATOR_KEY, this.validator);
            }
        }
    }

    private void initValidatorWithClassName(String className, String constructorArgClassName) {
        try {
            Object constructorArg = null;
            Class<?> constructorArgClass = null;
            if (constructorArgClassName != null) {
                try {
                    constructorArgClass = TypeUtil.forName(constructorArgClassName);
                    constructorArg = this.tideContext.findComponent(null, constructorArgClass);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Class<?> validatorClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            try {
                Constructor<?> c = validatorClass.getConstructor(constructorArgClass);
                this.validator = (EntityValidator)c.newInstance(constructorArg);
            }
            catch (NoSuchMethodException e) {
                this.validator = (EntityValidator)validatorClass.newInstance();
            }
            catch (InvocationTargetException e) {
                log.error(e, "Could not initialize Tide validator " + className + " with argument of type " + constructorArgClassName, new Object[0]);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
    }

    public InvalidValue[] validateObject(Object entity, String propertyName, Object value) {
        this.initValidator();
        if (entity != null && this.validator != null) {
            return this.validator.getPotentialInvalidValues(entity.getClass(), propertyName, value);
        }
        return EMPTY_INVALID_VALUES;
    }

    public void login() {
    }

    public void logout() {
        HttpGraniteContext context = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpSession session = context.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    public void resyncContext() {
    }

    protected TideServiceContext lookupContext() {
        return null;
    }

    protected TideServiceContext getTideContext() {
        return this.tideContext;
    }

    @Override
    protected Object adjustInvokee(RemotingMessage request, String methodName, Object[] args) throws ServiceException {
        if ("invokeComponent".equals(methodName)) {
            String componentName = (String)args[0];
            String componentClassName = (String)args[1];
            Class<?> componentClass = null;
            try {
                if (componentClassName != null) {
                    componentClass = TypeUtil.forName(componentClassName);
                }
            }
            catch (ClassNotFoundException e) {
                throw new ServiceException("Component class not found " + componentClassName, e);
            }
            log.debug("Setting invokee to %s", componentName);
            Object instance = this.tideContext.findComponent(componentName, componentClass);
            Set<Class<?>> componentClasses = instance != null ? this.tideContext.findComponentClasses(componentName, componentClass) : null;
            GraniteContext context = GraniteContext.getCurrentInstance();
            if (instance != null && componentClasses != null && context.getGraniteConfig().isComponentTideEnabled(componentName, componentClasses, instance)) {
                return this.tideContext.adjustInvokee(instance, componentName, componentClasses);
            }
            if (instance != null) {
                log.error("SECURITY CHECK: Remote call refused to a non Tide-enabled component: " + componentName + "." + args[1] + ", class: " + componentClasses + ", instance: " + instance, new Object[0]);
            }
            throw SecurityServiceException.newAccessDeniedException("Component [" + componentName + (componentClassName != null ? " of class " + componentClassName : "") + "] not found");
        }
        return super.adjustInvokee(request, methodName, args);
    }

    @Override
    protected Object[] beforeMethodSearch(Object invokee, String methodName, Object[] args) {
        if ("invokeComponent".equals(methodName)) {
            return this.tideContext.beforeMethodSearch(invokee, methodName, args);
        }
        if ("initializeObject".equals(methodName)) {
            return new Object[]{methodName, new Object[]{args[0], args[1]}};
        }
        if ("validateObject".equals(methodName)) {
            return new Object[]{methodName, new Object[]{args[0], args[1], args[2]}};
        }
        return new Object[]{methodName, new Object[0]};
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void beforeInvocation(ServiceInvocationContext context) {
        RemotingMessage message = (RemotingMessage)context.getMessage();
        GraniteContext graniteContext = GraniteContext.getCurrentInstance();
        Object[] originArgs = (Object[])message.getBody();
        IInvocationCall call = (IInvocationCall)originArgs[originArgs.length - 1];
        String operation = message.getOperation();
        String componentName = "invokeComponent".equals(operation) ? (String)originArgs[0] : null;
        String componentClassName = "invokeComponent".equals(operation) ? (String)originArgs[1] : null;
        Class<?> componentClass = null;
        try {
            if (componentClassName != null) {
                componentClass = TypeUtil.forName(componentClassName);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ServiceException("Component class not found " + componentClassName, classNotFoundException);
        }
        graniteContext.getRequestMap().put(TideServiceInvoker.class.getName(), this);
        if (componentName != null || componentClass != null) {
            Converters converters = graniteContext.getGraniteConfig().getConverters();
            Set<Class<?>> componentClasses = this.tideContext.findComponentClasses(componentName, componentClass);
            for (Class<?> cClass : componentClasses) {
                try {
                    Method m = cClass.getMethod(context.getMethod().getName(), context.getMethod().getParameterTypes());
                    int i = 0;
                    while (i < m.getGenericParameterTypes().length) {
                        context.getParameters()[i] = converters.convert(context.getParameters()[i], m.getGenericParameterTypes()[i]);
                        ++i;
                    }
                    break;
                }
                catch (NoSuchMethodException m) {
                    // empty catch block
                }
            }
            for (Class<?> cClass : componentClasses) {
                DataEnabled dataEnabled = cClass.getAnnotation(DataEnabled.class);
                if (dataEnabled == null || dataEnabled.useInterceptor()) continue;
                GraniteContext.getCurrentInstance().getRequestMap().put(DATAENABLED_HANDLED, true);
                DataContext.init(dataEnabled.topic(), dataEnabled.params(), dataEnabled.publish());
                this.prepareDataObserver(dataEnabled);
                break;
            }
        }
        Throwable throwable = null;
        try {
            try {
                this.tideContext.prepareCall(context, call, componentName, componentClass);
                return;
            }
            catch (ServiceException e) {
                ServiceException serviceException = e;
                if (serviceException == null) return;
                throw this.factory.getServiceExceptionHandler().handleInvocationException(context, serviceException);
            }
            catch (Throwable e) {
                void var10_16;
                if (e instanceof InvocationTargetException) {
                    Throwable throwable2 = ((InvocationTargetException)e).getTargetException();
                } else {
                    Throwable throwable3 = e;
                }
                if (var10_16 == null) return;
                throw this.factory.getServiceExceptionHandler().handleInvocationException(context, (Throwable)var10_16);
            }
        }
        finally {
            if (throwable != null) {
                throw this.factory.getServiceExceptionHandler().handleInvocationException(context, throwable);
            }
        }
    }

    protected void prepareDataObserver(DataEnabled dataEnabled) {
        DataContext.observe();
    }

    @Override
    protected Object afterInvocation(ServiceInvocationContext context, Object result) {
        IInvocationResult res;
        block28: {
            res = null;
            String componentName = null;
            Class<?> componentClass = null;
            try {
                Object[] originArgs = (Object[])context.getMessage().getBody();
                String operation = ((RemotingMessage)context.getMessage()).getOperation();
                componentName = "invokeComponent".equals(operation) ? (String)originArgs[0] : null;
                String componentClassName = "invokeComponent".equals(operation) ? (String)originArgs[1] : null;
                try {
                    if (componentClassName != null) {
                        componentClass = TypeUtil.forName(componentClassName);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new ServiceException("Component class not found " + componentClassName, e);
                }
            }
            catch (Throwable throwable) {
                block27: {
                    Throwable error = null;
                    try {
                        res = this.tideContext.postCall(context, result, componentName, componentClass);
                    }
                    catch (ServiceException e) {
                        error = e;
                        if (error != null) {
                            throw this.factory.getServiceExceptionHandler().handleInvocationException(context, error);
                        }
                        break block27;
                    }
                    catch (Throwable e) {
                        try {
                            if (e instanceof InvocationTargetException) {
                                error = ((InvocationTargetException)e).getTargetException();
                            }
                            error = e;
                            return error;
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                        finally {
                            if (error != null) {
                                throw this.factory.getServiceExceptionHandler().handleInvocationException(context, error);
                            }
                            break block27;
                        }
                    }
                    if (error == null) break block27;
                    throw this.factory.getServiceExceptionHandler().handleInvocationException(context, error);
                }
                throw throwable;
            }
            Throwable error = null;
            try {
                res = this.tideContext.postCall(context, result, componentName, componentClass);
            }
            catch (ServiceException e) {
                error = e;
                if (error != null) {
                    throw this.factory.getServiceExceptionHandler().handleInvocationException(context, error);
                }
                break block28;
            }
            catch (Throwable e) {
                try {
                    if (e instanceof InvocationTargetException) {
                        error = ((InvocationTargetException)e).getTargetException();
                    }
                    error = e;
                    return error;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (error != null) {
                        throw this.factory.getServiceExceptionHandler().handleInvocationException(context, error);
                    }
                    break block28;
                }
            }
            if (error == null) break block28;
            throw this.factory.getServiceExceptionHandler().handleInvocationException(context, error);
        }
        DataMergeContext.remove();
        if (GraniteContext.getCurrentInstance().getRequestMap().get(DATAENABLED_HANDLED) != null) {
            this.publishDataUpdates();
        }
        DataContext.remove();
        return res;
    }

    protected void publishDataUpdates() {
        DataContext.publish(DataEnabled.PublishMode.ON_SUCCESS);
    }

    @Override
    protected void afterInvocationError(ServiceInvocationContext context, Throwable error) {
        String componentName = null;
        Class<?> componentClass = null;
        try {
            Object[] originArgs = (Object[])context.getMessage().getBody();
            String operation = ((RemotingMessage)context.getMessage()).getOperation();
            componentName = "invokeComponent".equals(operation) ? (String)originArgs[0] : null;
            String componentClassName = "invokeComponent".equals(operation) ? (String)originArgs[1] : null;
            try {
                if (componentClassName != null) {
                    componentClass = TypeUtil.forName(componentClassName);
                }
            }
            catch (ClassNotFoundException e) {
                throw new ServiceException("Component class not found " + componentClassName, e);
            }
        }
        catch (Throwable throwable) {
            this.tideContext.postCallFault(context, error, componentName, componentClass);
            throw throwable;
        }
        this.tideContext.postCallFault(context, error, componentName, componentClass);
        DataMergeContext.remove();
        DataContext.remove();
    }
}

