/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.data;

import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import org.granite.logging.Logger;
import org.granite.tide.TideTransactionManager;
import org.granite.tide.data.AbstractTidePersistenceManager;
import org.granite.tide.data.JPATransactionManager;
import org.granite.tide.data.TideTransactionPersistenceManager;
import org.granite.util.Entity;

public class JPAPersistenceManager
extends AbstractTidePersistenceManager
implements TideTransactionPersistenceManager {
    private static final Logger log = Logger.getLogger(JPAPersistenceManager.class);
    protected EntityManager em;

    public JPAPersistenceManager(TideTransactionManager tm) {
        super(tm);
    }

    public JPAPersistenceManager(EntityManager em) {
        this(em, null);
    }

    public JPAPersistenceManager(EntityManager em, TideTransactionManager tm) {
        super(tm != null ? tm : new JPATransactionManager());
        if (em == null) {
            throw new RuntimeException("entity manager cannot be null");
        }
        this.em = em;
    }

    public JPAPersistenceManager(EntityManagerFactory emf) {
        this(emf, null);
    }

    public JPAPersistenceManager(EntityManagerFactory emf, TideTransactionManager tm) {
        super(tm != null ? tm : new JPATransactionManager());
        if (emf == null) {
            throw new RuntimeException("entity manager factory cannot be null");
        }
        this.em = emf.createEntityManager();
    }

    public Object getCurrentTransaction() {
        EntityTransaction et = this.em.getTransaction();
        et.begin();
        return et;
    }

    public Object fetchEntity(Object entity, String[] fetch) {
        Entity tideEntity = new Entity(entity);
        Serializable id = (Serializable)tideEntity.getIdentifier();
        if (id == null) {
            return null;
        }
        if (fetch == null || this.em.getDelegate().getClass().getName().indexOf(".hibernate.") < 0) {
            return this.em.find(entity.getClass(), (Object)id);
        }
        String[] stringArray = fetch;
        int n = fetch.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            Query q = this.em.createQuery("select e from " + entity.getClass().getName() + " e left join fetch e." + f + " where e = :entity");
            q.setParameter("entity", entity);
            List results = q.getResultList();
            if (!results.isEmpty()) {
                entity = results.get(0);
            } else {
                log.warn("Could not find entity %s to initialize, id: %s", entity.getClass().getName(), id);
            }
            ++n2;
        }
        return entity;
    }
}

