/*
 * Decompiled with CFR 0.152.
 */
package org.granite.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.granite.util.PropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Introspector {
    private static Map<Class<?>, PropertyDescriptor[]> descriptorCache = Collections.synchronizedMap(new WeakHashMap(128));

    public static String decapitalize(String name) {
        if (name == null) {
            return null;
        }
        if (name.length() == 0 || name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static void flushCaches() {
        descriptorCache.clear();
    }

    public static void flushFromCaches(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        descriptorCache.remove(clazz);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> beanClass) {
        PropertyDescriptor[] descriptor = descriptorCache.get(beanClass);
        if (descriptor == null) {
            descriptor = new BeanInfo(beanClass).getPropertyDescriptors();
            descriptorCache.put(beanClass, descriptor);
        }
        return descriptor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeanInfo {
        private Class<?> beanClass;
        private PropertyDescriptor[] properties = null;

        public BeanInfo(Class<?> beanClass) {
            this.beanClass = beanClass;
            if (this.properties == null) {
                this.properties = this.introspectProperties();
            }
        }

        public PropertyDescriptor[] getPropertyDescriptors() {
            return this.properties;
        }

        private PropertyDescriptor[] introspectProperties() {
            Method[] methods = this.beanClass.getMethods();
            ArrayList<Method> methodList = new ArrayList<Method>();
            Method[] methodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers())) {
                    methodList.add(method);
                }
                ++n2;
            }
            HashMap<String, Map<String, Object>> propertyMap = new HashMap<String, Map<String, Object>>(methodList.size());
            for (Method method : methodList) {
                BeanInfo.introspectGet(method, propertyMap);
                BeanInfo.introspectSet(method, propertyMap);
            }
            this.fixGetSet(propertyMap);
            ArrayList<PropertyDescriptor> propertyList = new ArrayList<PropertyDescriptor>();
            for (Map.Entry entry : propertyMap.entrySet()) {
                String propertyName = (String)entry.getKey();
                Map table = (Map)entry.getValue();
                if (table == null) continue;
                Method getter = (Method)table.get("getter");
                Method setter = (Method)table.get("setter");
                PropertyDescriptor propertyDesc = new PropertyDescriptor(propertyName, getter, setter);
                propertyList.add(propertyDesc);
            }
            PropertyDescriptor[] propertyDescriptorArray = new PropertyDescriptor[propertyList.size()];
            propertyList.toArray(propertyDescriptorArray);
            return propertyDescriptorArray;
        }

        private static void introspectGet(Method method, Map<String, Map<String, Object>> propertyMap) {
            ArrayList<Method> getters;
            String methodName = method.getName();
            if (!method.getName().startsWith("get") && !method.getName().startsWith("is")) {
                return;
            }
            if (method.getParameterTypes().length > 0 || method.getReturnType() == Void.TYPE) {
                return;
            }
            if (method.getName().startsWith("is") && method.getReturnType() != Boolean.TYPE) {
                return;
            }
            String propertyName = method.getName().startsWith("get") ? methodName.substring(3) : methodName.substring(2);
            Map<String, Object> table = propertyMap.get(propertyName = Introspector.decapitalize(propertyName));
            if (table == null) {
                table = new HashMap<String, Object>();
                propertyMap.put(propertyName, table);
            }
            if ((getters = (ArrayList<Method>)table.get("getters")) == null) {
                getters = new ArrayList<Method>();
                table.put("getters", getters);
            }
            getters.add(method);
        }

        private static void introspectSet(Method method, Map<String, Map<String, Object>> propertyMap) {
            ArrayList<Method> setters;
            String methodName = method.getName();
            if (!method.getName().startsWith("set")) {
                return;
            }
            if (method.getParameterTypes().length != 1 || method.getReturnType() != Void.TYPE) {
                return;
            }
            String propertyName = Introspector.decapitalize(methodName.substring(3));
            Map<String, Object> table = propertyMap.get(propertyName);
            if (table == null) {
                table = new HashMap<String, Object>();
                propertyMap.put(propertyName, table);
            }
            if ((setters = (ArrayList<Method>)table.get("setters")) == null) {
                setters = new ArrayList<Method>();
                table.put("setters", setters);
            }
            setters.add(method);
        }

        private void fixGetSet(Map<String, Map<String, Object>> propertyMap) {
            if (propertyMap == null) {
                return;
            }
            for (Map.Entry<String, Map<String, Object>> entry : propertyMap.entrySet()) {
                Map<String, Object> table = entry.getValue();
                ArrayList getters = (ArrayList)table.get("getters");
                ArrayList setters = (ArrayList)table.get("setters");
                if (getters == null) {
                    getters = new ArrayList();
                }
                if (setters == null) {
                    setters = new ArrayList();
                }
                Method definedGetter = getters.isEmpty() ? null : (Method)getters.get(0);
                Method definedSetter = null;
                if (definedGetter != null) {
                    Class<?> propertyType = definedGetter.getReturnType();
                    for (Method setter : setters) {
                        if (setter.getParameterTypes().length != 1 || !propertyType.equals(setter.getParameterTypes()[0])) continue;
                        definedSetter = setter;
                        break;
                    }
                    if (definedSetter != null && !setters.isEmpty()) {
                        definedSetter = (Method)setters.get(0);
                    }
                } else if (!setters.isEmpty()) {
                    definedSetter = (Method)setters.get(0);
                }
                table.put("getter", definedGetter);
                table.put("setter", definedSetter);
            }
        }
    }
}

