/*
 * Decompiled with CFR 0.152.
 */
package org.granite.util;

import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDescriptor {
    private String name;
    private Method getter;
    private Method setter;

    public PropertyDescriptor(String propertyName, Method getter, Method setter) {
        this.name = propertyName;
        this.setReadMethod(getter);
        this.setWriteMethod(setter);
    }

    public PropertyDescriptor(String propertyName, Class<?> beanClass) {
        this.name = propertyName;
        try {
            this.setReadMethod(beanClass, this.createDefaultMethodName(propertyName, "is"));
        }
        catch (Exception e) {
            this.setReadMethod(beanClass, this.createDefaultMethodName(propertyName, "get"));
        }
        this.setWriteMethod(beanClass, this.createDefaultMethodName(propertyName, "set"));
    }

    public String getName() {
        return this.name;
    }

    public void setWriteMethod(Method setter) {
        this.setter = setter;
    }

    public void setReadMethod(Method getter) {
        this.getter = getter;
    }

    public Method getWriteMethod() {
        return this.setter;
    }

    public Method getReadMethod() {
        return this.getter;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PropertyDescriptor)) {
            return false;
        }
        PropertyDescriptor pd = (PropertyDescriptor)object;
        if (!(this.getter == null && pd.getter == null || this.getter != null && this.getter.equals(pd.getter))) {
            return false;
        }
        if (!(this.setter == null && pd.setter == null || this.setter != null && this.setter.equals(pd.setter))) {
            return false;
        }
        return this.getPropertyType() == pd.getPropertyType();
    }

    public int hashCode() {
        int hashCode;
        int n = hashCode = this.getter != null ? this.getter.hashCode() : 0;
        if (this.setter != null) {
            hashCode = hashCode * 31 + this.setter.hashCode();
        }
        if (this.getPropertyType() != null) {
            hashCode = hashCode * 31 + this.getPropertyType().hashCode();
        }
        return hashCode;
    }

    public Class<?> getPropertyType() {
        if (this.getter != null) {
            return this.getter.getReturnType();
        }
        if (this.setter != null) {
            Class<?>[] parameterTypes = this.setter.getParameterTypes();
            return parameterTypes[0];
        }
        return null;
    }

    private String createDefaultMethodName(String propertyName, String prefix) {
        return String.valueOf(prefix) + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    }

    private void setReadMethod(Class<?> beanClass, String getterName) {
        try {
            Method readMethod = beanClass.getMethod(getterName, new Class[0]);
            this.setReadMethod(readMethod);
        }
        catch (Exception e) {
            throw new RuntimeException("Introspection exception", e);
        }
    }

    private void setWriteMethod(Class<?> beanClass, String setterName) {
        Method writeMethod = null;
        try {
            if (this.getter != null) {
                writeMethod = beanClass.getMethod(setterName, this.getter.getReturnType());
            } else {
                Class<?> clazz = beanClass;
                Method[] methods = null;
                while (clazz != null && writeMethod == null) {
                    Method[] methodArray = methods = clazz.getDeclaredMethods();
                    int n = methods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Method method = methodArray[n2];
                        if (setterName.equals(method.getName()) && method.getParameterTypes().length == 1) {
                            writeMethod = method;
                            break;
                        }
                        ++n2;
                    }
                    clazz = clazz.getSuperclass();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Introspection exception", e);
        }
        if (writeMethod == null) {
            throw new RuntimeException("Could not find setter for property " + this.name);
        }
        this.setWriteMethod(writeMethod);
    }
}

