/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.granite.config.ConfigProvider;
import org.granite.config.GraniteConfig;
import org.granite.config.ServletGraniteConfig;
import org.granite.config.ShutdownListener;
import org.granite.config.flex.Channel;
import org.granite.config.flex.Destination;
import org.granite.config.flex.EndPoint;
import org.granite.config.flex.Factory;
import org.granite.config.flex.Service;
import org.granite.config.flex.ServicesConfig;
import org.granite.config.flex.ServletServicesConfig;
import org.granite.config.servlet3.ServerFilter;
import org.granite.jmx.GraniteMBeanInitializer;
import org.granite.logging.Logger;
import org.granite.messaging.DefaultAliasRegistry;
import org.granite.messaging.amf.io.util.externalizer.BigDecimalExternalizer;
import org.granite.messaging.amf.io.util.externalizer.BigIntegerExternalizer;
import org.granite.messaging.amf.io.util.externalizer.LongExternalizer;
import org.granite.messaging.amf.process.AMF3MessageInterceptor;
import org.granite.messaging.jmf.DefaultCodecRegistry;
import org.granite.messaging.jmf.DefaultSharedContext;
import org.granite.messaging.jmf.SharedContext;
import org.granite.messaging.jmf.codec.ExtendedObjectCodec;
import org.granite.messaging.jmf.codec.ExtendedObjectCodecService;
import org.granite.messaging.reflect.Reflection;
import org.granite.messaging.service.ExceptionConverter;
import org.granite.messaging.service.ServiceFactory;
import org.granite.messaging.service.SimpleServiceFactory;
import org.granite.messaging.service.security.RemotingDestinationSecurizer;
import org.granite.messaging.service.security.SecurityService;
import org.granite.messaging.service.tide.TideComponentAnnotatedWithMatcher;
import org.granite.messaging.service.tide.TideComponentInstanceOfMatcher;
import org.granite.messaging.service.tide.TideComponentNameMatcher;
import org.granite.messaging.service.tide.TideComponentTypeMatcher;
import org.granite.scan.ServiceLoader;
import org.granite.util.JMFAMFUtil;
import org.granite.util.ServletParams;
import org.granite.util.TypeUtil;
import org.granite.util.XMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraniteConfigListener
implements ServletContextListener,
HttpSessionListener {
    private static final String GRANITE_CONFIG_SHUTDOWN_KEY = GraniteConfig.class.getName() + "_SHUTDOWN";
    public static final String GRANITE_CONFIG_ATTRIBUTE = "org.granite.config.serverFilter";
    public static final String GRANITE_CONFIG_PROVIDER_ATTRIBUTE = "org.granite.config.configProvider";
    public static final String GRANITE_MBEANS_ATTRIBUTE = "registerGraniteMBeans";
    public static final String GRANITE_SESSION_TRACKING = "org.granite.config.sessionTracking";
    public static final String GRANITE_SESSION_MAP = "org.granite.config.sessionMap";
    public static final String JMF_INITIALIZATION = "jmf-initialization";
    public static final String SHARED_CONTEXT_KEY = SharedContext.class.getName();
    public static final String DUMP_SHARED_CONTEXT_KEY = SharedContext.class.getName() + ":DUMP";
    private static final Logger log = Logger.getLogger(GraniteConfigListener.class);

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        try {
            String jmfInitialization;
            log.info("Initializing GraniteDS...", new Object[0]);
            Class serverFilterClass = (Class)context.getAttribute(GRANITE_CONFIG_ATTRIBUTE);
            if (serverFilterClass != null) {
                context.setAttribute(ServletGraniteConfig.GRANITE_CONFIG_DEFAULT_KEY, (Object)"org/granite/config/servlet3/granite-config-servlet3.xml");
            }
            GraniteConfig gConfig = ServletGraniteConfig.loadConfig(context);
            ServletServicesConfig.loadConfig(context);
            if (serverFilterClass != null) {
                this.configureServices(context, serverFilterClass);
            }
            if ("true".equals(context.getInitParameter(GRANITE_SESSION_TRACKING))) {
                ConcurrentHashMap sessionMap = new ConcurrentHashMap(200);
                context.setAttribute(GRANITE_SESSION_MAP, sessionMap);
            }
            if (gConfig.isRegisterMBeans()) {
                GraniteMBeanInitializer.registerMBeans(context, ServletGraniteConfig.getServletConfig(context), ServletServicesConfig.getServletConfig(context));
            }
            if ((jmfInitialization = context.getInitParameter(JMF_INITIALIZATION)) == null || "true".equals(jmfInitialization)) {
                GraniteConfigListener.loadJMFSharedContext(context, gConfig);
            }
            log.info("GraniteDS initialized", new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize Granite environment", e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        log.info("Stopping GraniteDS...", new Object[0]);
        List listeners = (List)sce.getServletContext().getAttribute(GRANITE_CONFIG_SHUTDOWN_KEY);
        if (listeners != null) {
            try {
                for (ShutdownListener listener : listeners) {
                    listener.stop();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not destroy Granite environment", e);
            }
        }
        if (ServletParams.get(context, GRANITE_MBEANS_ATTRIBUTE, Boolean.TYPE, Boolean.valueOf(false)).booleanValue()) {
            GraniteMBeanInitializer.unregisterMBeans(context);
        }
        log.info("GraniteDS stopped", new Object[0]);
    }

    public static synchronized void registerShutdownListener(ServletContext context, ShutdownListener listener) {
        ArrayList<ShutdownListener> listeners = (ArrayList<ShutdownListener>)context.getAttribute(GRANITE_CONFIG_SHUTDOWN_KEY);
        if (listeners == null) {
            listeners = new ArrayList<ShutdownListener>();
            context.setAttribute(GRANITE_CONFIG_SHUTDOWN_KEY, listeners);
        }
        listeners.add(listener);
    }

    private void configureServices(ServletContext servletContext, Class<?> serverFilterClass) throws ServletException {
        Service service;
        Factory factory;
        GraniteConfig graniteConfig = ServletGraniteConfig.loadConfig(servletContext);
        ServicesConfig servicesConfig = ServletServicesConfig.loadConfig(servletContext);
        ServerFilter serverFilter = serverFilterClass.getAnnotation(ServerFilter.class);
        ConfigProvider configProvider = null;
        boolean useTide = serverFilter.tide();
        String type = serverFilter.type();
        Class<? extends ServiceFactory> factoryClass = null;
        HashSet tideInterfaces = new HashSet(Arrays.asList(serverFilter.tideInterfaces()));
        HashSet<Class<? extends Annotation>> tideAnnotations = new HashSet<Class<? extends Annotation>>(Arrays.asList(serverFilter.tideAnnotations()));
        if (!serverFilter.configProviderClass().equals(ConfigProvider.class)) {
            try {
                configProvider = TypeUtil.newInstance(serverFilter.configProviderClass(), new Class[]{ServletContext.class}, new Object[]{servletContext});
                servletContext.setAttribute(GRANITE_CONFIG_PROVIDER_ATTRIBUTE, (Object)configProvider);
                if (configProvider.useTide() != null) {
                    useTide = configProvider.useTide();
                }
                if (configProvider.getType() != null) {
                    type = configProvider.getType();
                }
                factoryClass = configProvider.getFactoryClass();
                if (configProvider.getTideInterfaces() != null) {
                    tideInterfaces.addAll(Arrays.asList(configProvider.getTideInterfaces()));
                }
                if (configProvider.getTideAnnotations() != null) {
                    tideAnnotations.addAll(Arrays.asList(configProvider.getTideAnnotations()));
                }
            }
            catch (Exception e) {
                log.error(e, "Could not set config provider of type %s", serverFilter.configProviderClass().getName());
            }
        }
        if (!serverFilter.factoryClass().equals(ServiceFactory.class)) {
            factoryClass = serverFilter.factoryClass();
        }
        if (factoryClass == null) {
            factoryClass = SimpleServiceFactory.class;
            useTide = false;
        }
        for (Class clazz : tideInterfaces) {
            try {
                graniteConfig.getTideComponentMatchers().add(new TideComponentInstanceOfMatcher(clazz.getName(), false));
                log.debug("Enabled components implementing %s for Tide remoting", clazz);
            }
            catch (Exception e) {
                log.error(e, "Could not add tide-component interface %s", clazz);
            }
        }
        for (Class clazz : tideAnnotations) {
            try {
                graniteConfig.getTideComponentMatchers().add(new TideComponentAnnotatedWithMatcher(clazz.getName(), false));
                log.debug("Enabled components annotated with %s for Tide remoting", clazz);
            }
            catch (Exception e) {
                log.error(e, "Could not add tide-component annotation %s", clazz);
            }
        }
        for (String tn : serverFilter.tideNames()) {
            try {
                graniteConfig.getTideComponentMatchers().add(new TideComponentNameMatcher(tn, false));
                log.debug("Enabled components with name %s for Tide remoting", tn);
            }
            catch (Exception e) {
                log.error(e, "Could not add tide-component name %s", tn);
            }
        }
        for (String tt : serverFilter.tideTypes()) {
            try {
                graniteConfig.getTideComponentMatchers().add(new TideComponentTypeMatcher(tt, false));
                log.debug("Enabled components with type %s for Tide remoting", tt);
            }
            catch (Exception e) {
                log.error(e, "Could not add tide-component type %s", tt);
            }
        }
        for (Class<? extends ExceptionConverter> ec : serverFilter.exceptionConverters()) {
            graniteConfig.registerExceptionConverter(ec, true);
            log.debug("Registered exception converter %s", ec);
        }
        if (configProvider != null) {
            for (ExceptionConverter exceptionConverter : configProvider.findInstances(ExceptionConverter.class)) {
                graniteConfig.registerExceptionConverter(exceptionConverter, true);
                log.debug("Registered exception converter %s", exceptionConverter.getClass());
            }
        }
        if (serverFilter.useBigDecimal()) {
            graniteConfig.setExternalizersByType(BigDecimal.class.getName(), BigDecimalExternalizer.class.getName());
        }
        if (serverFilter.useBigInteger()) {
            graniteConfig.setExternalizersByType(BigInteger.class.getName(), BigIntegerExternalizer.class.getName());
        }
        if (serverFilter.useLong()) {
            graniteConfig.setExternalizersByType(Long.class.getName(), LongExternalizer.class.getName());
        }
        if (!serverFilter.securityServiceClass().equals(SecurityService.class)) {
            try {
                graniteConfig.setSecurityService(TypeUtil.newInstance(serverFilter.securityServiceClass(), SecurityService.class));
            }
            catch (Exception e) {
                throw new ServletException("Could not setup security service", (Throwable)e);
            }
        } else if (graniteConfig.getSecurityService() == null && configProvider != null) {
            SecurityService securityService = configProvider.findInstance(SecurityService.class);
            graniteConfig.setSecurityService(securityService);
        }
        if (graniteConfig.getSecurityService() == null) {
            String securityServiceClassName = null;
            try {
                TypeUtil.forName("org.mortbay.jetty.Request");
                securityServiceClassName = "org.granite.messaging.service.security.Jetty6SecurityService";
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    TypeUtil.forName("org.eclipse.jetty.server.Request");
                    securityServiceClassName = "org.granite.messaging.service.security.Jetty7SecurityService";
                }
                catch (ClassNotFoundException e1b) {
                    try {
                        TypeUtil.forName("weblogic.servlet.security.ServletAuthentication");
                        securityServiceClassName = "org.granite.messaging.service.security.WebLogicSecurityService";
                    }
                    catch (ClassNotFoundException e2) {
                        try {
                            TypeUtil.forName("com.sun.appserv.server.LifecycleEvent");
                            securityServiceClassName = "org.granite.messaging.service.security.GlassFishV3SecurityService";
                        }
                        catch (ClassNotFoundException e3) {
                            securityServiceClassName = "org.granite.messaging.service.security.Tomcat7SecurityService";
                        }
                    }
                    try {
                        graniteConfig.setSecurityService((SecurityService)TypeUtil.newInstance(securityServiceClassName));
                    }
                    catch (Exception e) {
                        throw new ServletException("Could not setup security service " + securityServiceClassName, (Throwable)e);
                    }
                }
            }
        }
        if (!serverFilter.amf3MessageInterceptor().equals(AMF3MessageInterceptor.class)) {
            try {
                graniteConfig.setAmf3MessageInterceptor(TypeUtil.newInstance(serverFilter.amf3MessageInterceptor(), AMF3MessageInterceptor.class));
            }
            catch (Exception e) {
                throw new ServletException("Could not setup amf3 message interceptor", (Throwable)e);
            }
        } else if (graniteConfig.getAmf3MessageInterceptor() == null && configProvider != null) {
            AMF3MessageInterceptor amf3MessageInterceptor = configProvider.findInstance(AMF3MessageInterceptor.class);
            graniteConfig.setAmf3MessageInterceptor(amf3MessageInterceptor);
        }
        Channel channel = servicesConfig.findChannelById("graniteamf");
        if (channel == null) {
            channel = new Channel("graniteamf", "mx.messaging.channels.AMFChannel", new EndPoint("http://{server.name}:{server.port}/{context.root}/graniteamf/amf", "flex.messaging.endpoints.AMFEndpoint"), new XMap());
            servicesConfig.addChannel(channel);
        }
        XMap xMap = new XMap();
        String lookup = null;
        if (useTide) {
            lookup = "java:global/{context.root}/{capitalized.component.name}Bean";
            if (GraniteConfigListener.isJBoss6()) {
                lookup = "{capitalized.component.name}Bean/local";
            }
            if (!"".equals(serverFilter.ejbLookup())) {
                lookup = serverFilter.ejbLookup();
            }
        } else {
            lookup = "java:global/{context.root}/{capitalized.destination.id}Bean";
            if (GraniteConfigListener.isJBoss6()) {
                lookup = "{capitalized.destination.id}Bean/local";
            }
            if (!"".equals(serverFilter.ejbLookup())) {
                lookup = serverFilter.ejbLookup();
            }
        }
        if (lookup.indexOf("{context.root}") >= 0) {
            try {
                Method m = servletContext.getClass().getMethod("getContextPath", new Class[0]);
                String contextPath = (String)m.invoke((Object)servletContext, new Object[0]);
                lookup = lookup.replace("{context.root}", contextPath.substring(1));
            }
            catch (Exception e) {
                log.error(e, "Could not get context path, please define lookup manually in @FlexFilter", new Object[0]);
            }
        }
        xMap.put("lookup", lookup);
        if (useTide) {
            factory = servicesConfig.findFactoryById("tide-" + type + "-factory");
            if (factory == null) {
                factory = new Factory("tide-" + type + "-factory", factoryClass.getName(), xMap);
                servicesConfig.addFactory(factory);
            }
            if ((service = servicesConfig.findServiceById("granite-service")) == null) {
                service = new Service("granite-service", "flex.messaging.services.RemotingService", "flex.messaging.messages.RemotingMessage", null, null, new HashMap<String, Destination>());
                ArrayList<String> channelIds = new ArrayList<String>();
                channelIds.add("graniteamf");
                List<String> tideRoles = serverFilter.tideRoles().length == 0 ? null : Arrays.asList(serverFilter.tideRoles());
                Destination destination = new Destination(type, channelIds, new XMap(), tideRoles, null, null);
                destination.getProperties().put("factory", "tide-" + type + "-factory");
                if (!"".equals(serverFilter.entityManagerFactoryJndiName())) {
                    destination.getProperties().put("entity-manager-factory-jndi-name", serverFilter.entityManagerFactoryJndiName());
                } else if (!"".equals(serverFilter.entityManagerJndiName())) {
                    destination.getProperties().put("entity-manager-jndi-name", serverFilter.entityManagerJndiName());
                }
                if (!"".equals(serverFilter.validatorClassName())) {
                    destination.getProperties().put("validator-class-name", serverFilter.validatorClassName());
                }
                service.getDestinations().put(type, destination);
                if (destination.getSecurizer() == null && configProvider != null) {
                    RemotingDestinationSecurizer securizer = configProvider.findInstance(RemotingDestinationSecurizer.class);
                    destination.setSecurizer(securizer);
                }
                servicesConfig.addService(service);
            }
            if (factoryClass.getName().equals("org.granite.tide.ejb.EjbServiceFactory")) {
                servicesConfig.scan(null);
            }
            log.info("Registered Tide " + factoryClass + " service factory and " + type + " destination", new Object[0]);
        } else {
            factory = new Factory(type + "-factory", factoryClass.getName(), xMap);
            servicesConfig.addFactory(factory);
            service = new Service("granite-service", "flex.messaging.services.RemotingService", "flex.messaging.messages.RemotingMessage", null, null, new HashMap<String, Destination>());
            servicesConfig.addService(service);
            servicesConfig.scan(null);
            log.info("Registered " + factoryClass + " service factory", new Object[0]);
        }
    }

    private static boolean isJBoss6() {
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("/org/jboss/version.properties");
            if (is != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static void loadJMFSharedContext(ServletContext servletContext, GraniteConfig graniteConfig) {
        log.info("Loading JMF shared context", new Object[0]);
        List<ExtendedObjectCodec> extendedObjectCodecs = null;
        if (graniteConfig.getJmfExtendedCodecsMode() == GraniteConfig.JMF_EXTENSIONS_MODE.REPLACE) {
            extendedObjectCodecs = graniteConfig.getJmfExtendedCodecs();
        } else {
            extendedObjectCodecs = new ArrayList<ExtendedObjectCodec>();
            if (graniteConfig.getJmfExtendedCodecsMode() == GraniteConfig.JMF_EXTENSIONS_MODE.PREPPEND) {
                extendedObjectCodecs.addAll(graniteConfig.getJmfExtendedCodecs());
            }
            for (ExtendedObjectCodecService service : ServiceLoader.load(ExtendedObjectCodecService.class)) {
                extendedObjectCodecs.addAll(Arrays.asList(service.getExtensions()));
            }
            if (graniteConfig.getJmfExtendedCodecsMode() == GraniteConfig.JMF_EXTENSIONS_MODE.APPEND) {
                extendedObjectCodecs.addAll(graniteConfig.getJmfExtendedCodecs());
            }
        }
        log.debug("Using JMF extended codecs: %s", extendedObjectCodecs);
        List<String> defaultStoredStrings = null;
        if (graniteConfig.getJmfDefaultStoredStringsMode() == GraniteConfig.JMF_EXTENSIONS_MODE.REPLACE) {
            defaultStoredStrings = graniteConfig.getJmfDefaultStoredStrings();
        } else {
            defaultStoredStrings = new ArrayList<String>();
            if (graniteConfig.getJmfDefaultStoredStringsMode() == GraniteConfig.JMF_EXTENSIONS_MODE.PREPPEND) {
                defaultStoredStrings.addAll(graniteConfig.getJmfDefaultStoredStrings());
            }
            defaultStoredStrings.addAll(JMFAMFUtil.AMF_DEFAULT_STORED_STRINGS);
            if (graniteConfig.getJmfDefaultStoredStringsMode() == GraniteConfig.JMF_EXTENSIONS_MODE.APPEND) {
                defaultStoredStrings.addAll(graniteConfig.getJmfDefaultStoredStrings());
            }
        }
        log.debug("Using JMF default stored strings: %s", defaultStoredStrings);
        Reflection reflection = graniteConfig.getJmfReflection();
        log.debug("Using JMF reflection: %s", reflection.getClass().getName());
        DefaultAliasRegistry aliasRegistry = new DefaultAliasRegistry();
        DefaultSharedContext sharedContext = new DefaultSharedContext(new DefaultCodecRegistry(extendedObjectCodecs), defaultStoredStrings, reflection, aliasRegistry);
        servletContext.setAttribute(SHARED_CONTEXT_KEY, (Object)sharedContext);
        DefaultSharedContext dumpSharedContext = new DefaultSharedContext(new DefaultCodecRegistry(), defaultStoredStrings, reflection, aliasRegistry);
        servletContext.setAttribute(DUMP_SHARED_CONTEXT_KEY, (Object)dumpSharedContext);
        log.info("JMF shared context loaded", new Object[0]);
    }

    public static SharedContext getSharedContext(ServletContext servletContext) {
        return (SharedContext)servletContext.getAttribute(SHARED_CONTEXT_KEY);
    }

    public static SharedContext getDumpSharedContext(ServletContext servletContext) {
        return (SharedContext)servletContext.getAttribute(DUMP_SHARED_CONTEXT_KEY);
    }

    public static ServletException newSharedContextNotInitializedException() {
        return new ServletException("JMF shared context not initialized (remove or set to true 'jmf-initialization' param in your web.xml)");
    }

    public void sessionCreated(HttpSessionEvent se) {
        Map sessionMap = (Map)se.getSession().getServletContext().getAttribute(GRANITE_SESSION_MAP);
        if (sessionMap != null) {
            sessionMap.put(se.getSession().getId(), se.getSession());
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        Map sessionMap = (Map)se.getSession().getServletContext().getAttribute(GRANITE_SESSION_MAP);
        if (sessionMap != null) {
            sessionMap.remove(se.getSession().getId());
        }
    }
}

