/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.granite.config.ConfigProvider;
import org.granite.config.GraniteConfig;
import org.granite.config.GraniteConfigListener;
import org.granite.config.ServletGraniteConfig;
import org.granite.config.flex.ServicesConfig;
import org.granite.config.flex.ServletServicesConfig;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityConfig;
import org.granite.gravity.GravityFactory;
import org.granite.gravity.config.AbstractActiveMQTopicDestination;
import org.granite.gravity.config.AbstractJmsTopicDestination;
import org.granite.gravity.config.AbstractMessagingDestination;
import org.granite.gravity.config.servlet3.ActiveMQTopicDestination;
import org.granite.gravity.config.servlet3.JmsTopicDestination;
import org.granite.gravity.config.servlet3.MessagingDestination;
import org.granite.gravity.security.GravityDestinationSecurizer;
import org.granite.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GravityManager {
    private static final String GRAVITY_KEY = Gravity.class.getName();

    public static Gravity start(ServletConfig servletConfig) throws ServletException {
        return GravityManager.start(servletConfig.getServletContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Gravity start(ServletContext context) throws ServletException {
        Gravity gravity = null;
        ServletContext servletContext = context;
        synchronized (servletContext) {
            gravity = (Gravity)context.getAttribute(GRAVITY_KEY);
            if (gravity == null) {
                GraniteConfig graniteConfig = ServletGraniteConfig.loadConfig(context);
                ServicesConfig servicesConfig = ServletServicesConfig.loadConfig(context);
                Class serverFilterClass = (Class)context.getAttribute("org.granite.config.serverFilter");
                if (serverFilterClass != null) {
                    GravityManager.configureServices(context, serverFilterClass);
                }
                GravityConfig gravityConfig = new GravityConfig(graniteConfig);
                String gravityFactory = gravityConfig.getGravityFactory();
                try {
                    GravityFactory factory = TypeUtil.newInstance(gravityFactory, GravityFactory.class);
                    gravity = factory.newGravity(gravityConfig, servicesConfig, graniteConfig);
                }
                catch (Exception e) {
                    throw new ServletException("Could not create Gravity instance with factory: " + gravityFactory, (Throwable)e);
                }
                try {
                    gravity.start();
                    context.setAttribute(GRAVITY_KEY, (Object)gravity);
                    GraniteConfigListener.registerShutdownListener(context, gravity);
                }
                catch (Exception e) {
                    throw new ServletException("Gravity initialization error", (Throwable)e);
                }
            }
        }
        return gravity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reconfigure(ServletContext context, GravityConfig gravityConfig) {
        ServletContext servletContext = context;
        synchronized (servletContext) {
            Gravity gravity = GravityManager.getGravity(context);
            gravity.reconfigure(gravityConfig, ServletGraniteConfig.getConfig(context));
        }
    }

    public static Gravity getGravity(ServletContext context) {
        return (Gravity)context.getAttribute(GRAVITY_KEY);
    }

    private static void configureServices(ServletContext servletContext, Class<?> serverFilterClass) throws ServletException {
        ServicesConfig servicesConfig = ServletServicesConfig.loadConfig(servletContext);
        ConfigProvider configProvider = (ConfigProvider)servletContext.getAttribute("org.granite.config.configProvider");
        for (Field field : serverFilterClass.getDeclaredFields()) {
            AbstractMessagingDestination messagingDestination;
            Annotation md;
            if (field.isAnnotationPresent(MessagingDestination.class)) {
                md = field.getAnnotation(MessagingDestination.class);
                messagingDestination = new AbstractMessagingDestination();
                messagingDestination.setId(field.getName());
                messagingDestination.setNoLocal(md.noLocal());
                messagingDestination.setSessionSelector(md.sessionSelector());
                GravityManager.initSecurizer(messagingDestination, md.securizer(), configProvider);
                messagingDestination.initServices(servicesConfig);
                continue;
            }
            if (field.isAnnotationPresent(JmsTopicDestination.class)) {
                md = field.getAnnotation(JmsTopicDestination.class);
                messagingDestination = new AbstractJmsTopicDestination();
                messagingDestination.setId(field.getName());
                messagingDestination.setNoLocal(md.noLocal());
                messagingDestination.setSessionSelector(md.sessionSelector());
                GravityManager.initSecurizer(messagingDestination, md.securizer(), configProvider);
                messagingDestination.initServices(servicesConfig);
                ((AbstractJmsTopicDestination)messagingDestination).setName(md.name());
                ((AbstractJmsTopicDestination)messagingDestination).setTextMessages(md.textMessages());
                ((AbstractJmsTopicDestination)messagingDestination).setAcknowledgeMode(md.acknowledgeMode());
                ((AbstractJmsTopicDestination)messagingDestination).setConnectionFactory(md.connectionFactory());
                ((AbstractJmsTopicDestination)messagingDestination).setTransactedSessions(md.transactedSessions());
                ((AbstractJmsTopicDestination)messagingDestination).setJndiName(md.topicJndiName());
                messagingDestination.initServices(servicesConfig);
                continue;
            }
            if (!field.isAnnotationPresent(ActiveMQTopicDestination.class)) continue;
            md = field.getAnnotation(ActiveMQTopicDestination.class);
            messagingDestination = new AbstractActiveMQTopicDestination();
            messagingDestination.setId(field.getName());
            messagingDestination.setNoLocal(md.noLocal());
            messagingDestination.setSessionSelector(md.sessionSelector());
            GravityManager.initSecurizer(messagingDestination, md.securizer(), configProvider);
            messagingDestination.initServices(servicesConfig);
            ((AbstractJmsTopicDestination)messagingDestination).setName(md.name());
            ((AbstractJmsTopicDestination)messagingDestination).setTextMessages(md.textMessages());
            ((AbstractJmsTopicDestination)messagingDestination).setAcknowledgeMode(md.acknowledgeMode());
            ((AbstractJmsTopicDestination)messagingDestination).setConnectionFactory(md.connectionFactory());
            ((AbstractJmsTopicDestination)messagingDestination).setTransactedSessions(md.transactedSessions());
            ((AbstractJmsTopicDestination)messagingDestination).setJndiName(md.topicJndiName());
            ((AbstractActiveMQTopicDestination)messagingDestination).setBrokerUrl(md.brokerUrl());
            ((AbstractActiveMQTopicDestination)messagingDestination).setCreateBroker(md.createBroker());
            ((AbstractActiveMQTopicDestination)messagingDestination).setDurable(md.durable());
            ((AbstractActiveMQTopicDestination)messagingDestination).setWaitForStart(md.waitForStart());
            ((AbstractActiveMQTopicDestination)messagingDestination).setFileStoreRoot(md.fileStoreRoot());
            messagingDestination.initServices(servicesConfig);
        }
    }

    private static void initSecurizer(AbstractMessagingDestination messagingDestination, Class<? extends GravityDestinationSecurizer> securizerClass, ConfigProvider configProvider) {
        if (securizerClass != GravityDestinationSecurizer.class) {
            if (configProvider != null) {
                messagingDestination.setSecurizer(configProvider.findInstance(securizerClass));
            }
            if (messagingDestination.getSecurizer() == null) {
                messagingDestination.setSecurizerClassName(securizerClass.getName());
            }
        }
    }
}

