/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.adapters;

import javax.jms.Destination;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQTopic;
import org.granite.gravity.adapters.JMSServiceAdapter;
import org.granite.logging.Logger;
import org.granite.messaging.service.ServiceException;
import org.granite.util.XMap;

public class ActiveMQServiceAdapter
extends JMSServiceAdapter {
    private static final Logger log = Logger.getLogger(ActiveMQServiceAdapter.class);

    public void configure(XMap adapterProperties, XMap destinationProperties) throws ServiceException {
        try {
            this.destinationName = destinationProperties.get("jms/destination-name");
            if (Boolean.TRUE.toString().equals(destinationProperties.get("jms/transacted-sessions"))) {
                this.transactedSessions = true;
            }
            if ("AUTO_ACKNOWLEDGE".equals(destinationProperties.get("jms/acknowledge-mode"))) {
                this.acknowledgeMode = 1;
            } else if ("CLIENT_ACKNOWLEDGE".equals(destinationProperties.get("jms/acknowledge-mode"))) {
                this.acknowledgeMode = 2;
            } else if ("DUPS_OK_ACKNOWLEDGE".equals(destinationProperties.get("jms/acknowledge-mode"))) {
                this.acknowledgeMode = 3;
            }
            if ("javax.jms.TextMessage".equals(destinationProperties.get("jms/message-type"))) {
                this.textMessages = true;
            }
            if (Boolean.TRUE.toString().equals(destinationProperties.get("jms/no-local"))) {
                this.noLocal = true;
            }
            if (Boolean.TRUE.toString().equals(destinationProperties.get("session-selector"))) {
                this.sessionSelector = true;
            }
            this.failoverRetryInterval = destinationProperties.get("jms/failover-retry-interval", Long.TYPE, 1000L);
            if (this.failoverRetryInterval <= 0L) {
                log.warn("Illegal failover retry interval: %d (using default %d)", this.failoverRetryInterval, 1000L);
                this.failoverRetryInterval = 1000L;
            }
            this.failoverRetryCount = destinationProperties.get("jms/failover-retry-count", Integer.TYPE, 4);
            if (this.failoverRetryCount <= 0) {
                log.warn("Illegal failover retry count: %s (using default %d)", this.failoverRetryCount, 4);
                this.failoverRetryCount = 4;
            }
            StringBuilder sb = null;
            if (destinationProperties.get("server/broker-url") != null && !"".equals(destinationProperties.get("server/broker-url").trim())) {
                sb = new StringBuilder(destinationProperties.get("server/broker-url"));
            } else {
                sb = new StringBuilder("vm://");
                sb.append(this.getId());
                if (Boolean.FALSE.toString().equals(destinationProperties.get("server/create-broker"))) {
                    sb.append("?create=false");
                    String startupWait = destinationProperties.get("server/wait-for-start");
                    if (startupWait != null) {
                        sb.append("&waitForStart=" + startupWait);
                    }
                } else {
                    sb.append("?create=true");
                }
                if (Boolean.TRUE.toString().equals(destinationProperties.get("server/durable"))) {
                    sb.append("&broker.persistent=true");
                    if (destinationProperties.containsKey("server/file-store-root")) {
                        sb.append("&broker.dataDirectory=").append(destinationProperties.get("server/file-store-root"));
                    }
                } else {
                    sb.append("&broker.persistent=false");
                }
            }
            String brokerURL = sb.toString();
            if (destinationProperties.get("server/username") != null && !"".equals(destinationProperties.get("server/username").trim()) && destinationProperties.get("server/password") != null && !"".equals(destinationProperties.get("server/password").trim())) {
                String username = destinationProperties.get("server/username");
                String password = destinationProperties.get("server/password");
                this.jmsConnectionFactory = new ActiveMQConnectionFactory(username, password, brokerURL);
            } else {
                this.jmsConnectionFactory = new ActiveMQConnectionFactory(brokerURL);
            }
        }
        catch (Exception e) {
            throw new ServiceException("Error when configuring JMS Adapter", e);
        }
    }

    protected Destination getProducerDestination(String topic) {
        return new ActiveMQTopic(topic != null ? this.destinationName + "." + topic.replaceAll("\\*\\*", ">") : this.destinationName);
    }

    protected Destination getConsumerDestination(String topic) {
        return new ActiveMQTopic(topic != null ? this.destinationName + "." + topic.replaceAll("\\*\\*", ">") : this.destinationName);
    }
}

