/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.config;

import org.granite.config.flex.Adapter;
import org.granite.config.flex.Destination;
import org.granite.gravity.config.AbstractMessagingDestination;
import org.granite.util.XMap;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Scope;

@Scope(value=ScopeType.APPLICATION)
public class AbstractJmsTopicDestination
extends AbstractMessagingDestination {
    private String name = null;
    private String connectionFactoryJndiName = null;
    private String destinationJndiName = null;
    private String acknowledgeMode = null;
    private boolean textMessages = false;
    private boolean transactedSessions = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getConnectionFactory() {
        return this.connectionFactoryJndiName;
    }

    public void setConnectionFactory(String connectionFactoryJndiName) {
        this.connectionFactoryJndiName = connectionFactoryJndiName;
    }

    public String getJndiName() {
        return this.destinationJndiName;
    }

    public void setJndiName(String jndiName) {
        this.destinationJndiName = jndiName;
    }

    public String getDestinationJndiName() {
        return this.destinationJndiName;
    }

    public void setDestinationJndiName(String jndiName) {
        this.destinationJndiName = jndiName;
    }

    public String getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(String acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public boolean isTextMessages() {
        return this.textMessages;
    }

    public void setTextMessages(boolean textMessages) {
        this.textMessages = textMessages;
    }

    public boolean isTransactedSessions() {
        return this.transactedSessions;
    }

    public void setTransactedSessions(boolean transactedSessions) {
        this.transactedSessions = transactedSessions;
    }

    protected Adapter buildAdapter() {
        return new Adapter("jms-adapter", "org.granite.gravity.adapters.JMSServiceAdapter", new XMap());
    }

    protected Destination buildDestination(Adapter adapter) {
        Destination destination = super.buildDestination(adapter);
        destination.getProperties().put("jms", null);
        destination.getProperties().put("jms/destination-type", "Topic");
        destination.getProperties().put("jms/destination-name", this.name);
        destination.getProperties().put("jms/destination-jndi-name", this.destinationJndiName);
        destination.getProperties().put("jms/connection-factory", this.connectionFactoryJndiName);
        if (this.textMessages) {
            destination.getProperties().put("jms/message-type", "javax.jms.TextMessage");
        }
        destination.getProperties().put("jms/acknowledge-mode", this.acknowledgeMode);
        destination.getProperties().put("jms/transacted-sessions", String.valueOf(this.transactedSessions));
        destination.getProperties().put("jms/no-local", String.valueOf(this.isNoLocal()));
        return destination;
    }
}

