/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.granite.config.AbstractFrameworkGraniteConfig;
import org.granite.config.flex.Adapter;
import org.granite.config.flex.Channel;
import org.granite.config.flex.Destination;
import org.granite.config.flex.EndPoint;
import org.granite.config.flex.Service;
import org.granite.config.flex.ServicesConfig;
import org.granite.gravity.security.GravityDestinationSecurizer;
import org.granite.logging.Logger;
import org.granite.util.XMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractMessagingDestination {
    private static final Logger log = Logger.getLogger(AbstractMessagingDestination.class);
    private String id = null;
    private List<String> roles = null;
    private String securizerClassName = null;
    private GravityDestinationSecurizer securizer = null;
    private boolean noLocal = false;
    private boolean sessionSelector = false;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public boolean isSessionSelector() {
        return this.sessionSelector;
    }

    public void setSessionSelector(boolean sessionSelector) {
        this.sessionSelector = sessionSelector;
    }

    public String getSecurizerClassName() {
        return this.securizerClassName;
    }

    public void setSecurizerClassName(String securizerClassName) {
        this.securizerClassName = securizerClassName;
    }

    public GravityDestinationSecurizer getSecurizer() {
        return this.securizer;
    }

    public void setSecurizer(GravityDestinationSecurizer securizer) {
        this.securizer = securizer;
    }

    protected void init(AbstractFrameworkGraniteConfig graniteConfig) {
        ServicesConfig servicesConfig = graniteConfig.getServicesConfig();
        this.initServices(servicesConfig);
    }

    public void initServices(ServicesConfig servicesConfig) {
        Channel channel = servicesConfig.findChannelById("gravityamf");
        if (channel == null) {
            channel = new Channel("gravityamf", "org.granite.gravity.channels.GravityChannel", new EndPoint("http://{server.name}:{server.port}/{context.root}/gravityamf/amf", "flex.messaging.endpoints.AMFEndpoint"), new XMap());
            servicesConfig.addChannel(channel);
        }
        List<Service> services = servicesConfig.findServicesByMessageType("flex.messaging.messages.AsyncMessage");
        Service service = null;
        Adapter adapter = null;
        if (services == null || services.isEmpty()) {
            adapter = this.buildAdapter();
            HashMap<String, Adapter> adapters = new HashMap<String, Adapter>();
            adapters.put(adapter.getId(), adapter);
            service = new Service("gravity-service", "flex.messaging.services.MessagingService", "flex.messaging.messages.AsyncMessage", adapter, adapters, new HashMap<String, Destination>());
            servicesConfig.addService(service);
        } else {
            Adapter ad;
            service = services.get(0);
            adapter = service.findAdapterById((ad = this.buildAdapter()).getId());
            if (adapter == null) {
                adapter = ad;
                service.addAdapter(adapter);
            }
        }
        service.getDestinations().put(this.id, this.buildDestination(adapter));
        log.info("Registered messaging destination %s", this.id);
    }

    protected Adapter buildAdapter() {
        return new Adapter("simple-adapter", "org.granite.gravity.adapters.SimpleServiceAdapter", new XMap());
    }

    protected Destination buildDestination(Adapter adapter) {
        ArrayList<String> channelIds = new ArrayList<String>();
        channelIds.add("gravityamf");
        Destination destination = new Destination(this.id, channelIds, new XMap(), this.roles, adapter, null);
        destination.getProperties().put("no-local", String.valueOf(this.noLocal));
        destination.getProperties().put("session-selector", String.valueOf(this.sessionSelector));
        if (this.getSecurizerClassName() != null) {
            destination.getProperties().put("securizer", this.securizerClassName);
        }
        if (this.getSecurizer() != null) {
            destination.setSecurizer(this.getSecurizer());
        }
        return destination;
    }
}

