/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.gae;

import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import flex.messaging.messages.Message;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.ServicesConfig;
import org.granite.gravity.Channel;
import org.granite.gravity.ChannelFactory;
import org.granite.gravity.DefaultGravity;
import org.granite.gravity.GravityConfig;
import org.granite.gravity.Subscription;
import org.granite.util.UUIDUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GAEGravity
extends DefaultGravity {
    static final String CHANNEL_PREFIX = "org.granite.gravity.gae.channel.";
    private static MemcacheService gaeCache = MemcacheServiceFactory.getMemcacheService();

    public GAEGravity(GravityConfig gravityConfig, ServicesConfig servicesConfig, GraniteConfig graniteConfig) {
        super(gravityConfig, servicesConfig, graniteConfig);
    }

    @Override
    protected <C extends Channel> C createChannel(ChannelFactory<C> channelFactory, String channelId) {
        Channel channel = null;
        if (channelId != null && (channel = (Channel)this.getChannel(channelFactory, channelId)) != null) {
            return (C)channel;
        }
        channel = (Channel)channelFactory.newChannel(UUIDUtil.randomUUID(), null);
        Expiration expiration = Expiration.byDeltaMillis((int)((int)this.getGravityConfig().getChannelIdleTimeoutMillis()));
        gaeCache.put((Object)(CHANNEL_PREFIX + channel.getId()), (Object)channel, expiration);
        gaeCache.put((Object)("org.granite.gravity.channel.msgCount." + channel.getId()), (Object)0L, expiration);
        return (C)channel;
    }

    @Override
    public <C extends Channel> C getChannel(ChannelFactory<C> channelFactory, String channelId) {
        if (channelId == null) {
            return null;
        }
        return (C)((Channel)gaeCache.get((Object)(CHANNEL_PREFIX + channelId)));
    }

    @Override
    public Channel removeChannel(String channelId) {
        if (channelId == null) {
            return null;
        }
        Channel channel = (Channel)gaeCache.get((Object)(CHANNEL_PREFIX + channelId));
        if (channel != null) {
            for (Subscription subscription : channel.getSubscriptions()) {
                Message message = subscription.getUnsubscribeMessage();
                this.handleMessage(channel.getFactory(), message, true);
            }
            channel.destroy();
            gaeCache.delete((Object)(CHANNEL_PREFIX + channelId));
            gaeCache.delete((Object)("org.granite.gravity.channel.msgCount." + channelId));
        }
        return channel;
    }

    @Override
    public boolean access(String channelId) {
        return true;
    }

    @Override
    public void internalStart() {
    }

    @Override
    protected void postManage(Channel channel) {
        Expiration expiration = Expiration.byDeltaMillis((int)((int)this.getGravityConfig().getChannelIdleTimeoutMillis()));
        gaeCache.put((Object)(CHANNEL_PREFIX + channel.getId()), (Object)channel, expiration);
    }
}

