/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.gae;

import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import java.util.concurrent.ConcurrentHashMap;
import org.granite.gravity.Channel;
import org.granite.gravity.adapters.ServiceAdapter;
import org.granite.gravity.gae.GAETopic;
import org.granite.gravity.gae.GAETopicId;
import org.granite.logging.Logger;
import org.granite.messaging.service.ServiceException;
import org.granite.util.XMap;

public class GAEServiceAdapter
extends ServiceAdapter {
    private static final Logger log = Logger.getLogger(GAEServiceAdapter.class);
    private final GAETopic rootTopic = new GAETopic("/", this);
    private transient ConcurrentHashMap<String, GAETopicId> _topicIdCache;
    private boolean noLocal = false;

    public void configure(XMap adapterProperties, XMap destinationProperties) throws ServiceException {
        this._topicIdCache = new ConcurrentHashMap();
        if (Boolean.TRUE.toString().equals(destinationProperties.get("no-local"))) {
            this.noLocal = true;
        }
    }

    public GAETopic getTopic(GAETopicId id) {
        return this.rootTopic.getChild(id);
    }

    public GAETopic getTopic(String id) {
        GAETopicId cid = this.getTopicId(id);
        if (cid.depth() == 0) {
            return null;
        }
        return this.rootTopic.getChild(cid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GAETopic getTopic(String id, boolean create) {
        GAEServiceAdapter gAEServiceAdapter = this;
        synchronized (gAEServiceAdapter) {
            GAETopic topic = this.getTopic(id);
            if (topic == null && create) {
                topic = new GAETopic(id, this);
                this.rootTopic.addChild(topic);
                log.debug("New Topic: %s", topic);
            }
            return topic;
        }
    }

    public GAETopicId getTopicId(String id) {
        GAETopicId tmpTid;
        GAETopicId tid = this._topicIdCache.get(id);
        if (tid == null && (tmpTid = this._topicIdCache.putIfAbsent(id, tid = new GAETopicId(id))) != null) {
            tid = tmpTid;
        }
        return tid;
    }

    public boolean hasTopic(String id) {
        GAETopicId cid = this.getTopicId(id);
        return this.rootTopic.getChild(cid) != null;
    }

    public Object invoke(Channel fromChannel, AsyncMessage message) {
        String topicId = GAETopicId.normalize((String)message.getHeader("DSSubtopic"));
        AcknowledgeMessage reply = null;
        if (message.getBody() != null && this.getSecurityPolicy().canPublish(fromChannel, topicId, message)) {
            GAETopicId tid = this.getTopicId(topicId);
            this.rootTopic.publish(tid, fromChannel, message);
            reply = new AcknowledgeMessage(message);
            reply.setMessageId(message.getMessageId());
        } else {
            reply = new ErrorMessage((Message)message, null);
            ((ErrorMessage)reply).setFaultString("unknown channel");
        }
        return reply;
    }

    public Object manage(Channel fromChannel, CommandMessage message) {
        AcknowledgeMessage reply = null;
        if (message.getOperation() == 0) {
            String subscribeTopicId = GAETopicId.normalize((String)message.getHeader("DSSubtopic"));
            if (this.getSecurityPolicy().canSubscribe(fromChannel, subscribeTopicId, message)) {
                GAETopic topic = this.getTopic(subscribeTopicId);
                if (topic == null && this.getSecurityPolicy().canCreate(fromChannel, subscribeTopicId, message)) {
                    topic = this.getTopic(subscribeTopicId, true);
                }
                if (topic != null) {
                    String subscriptionId = (String)message.getHeader("DSDstClientId");
                    String selector = (String)message.getHeader("DSSelector");
                    topic.subscribe(fromChannel, message.getDestination(), subscriptionId, selector, this.noLocal);
                    reply = new AcknowledgeMessage(message);
                } else {
                    reply = new ErrorMessage((Message)message, null);
                    ((ErrorMessage)reply).setFaultString("cannot create");
                }
            } else {
                reply = new ErrorMessage((Message)message, null);
                ((ErrorMessage)reply).setFaultString("cannot subscribe");
            }
        } else if (message.getOperation() == 1) {
            String unsubscribeTopicId = GAETopicId.normalize((String)message.getHeader("DSSubtopic"));
            GAETopic topic = this.getTopic(unsubscribeTopicId);
            String subscriptionId = null;
            if (topic != null) {
                subscriptionId = (String)message.getHeader("DSDstClientId");
                topic.unsubscribe(fromChannel, subscriptionId);
            }
            reply = new AcknowledgeMessage(message);
            reply.setHeader("DSDstClientId", subscriptionId);
        } else {
            reply = new ErrorMessage((Message)message, null);
            ((ErrorMessage)reply).setFaultString("unknown operation");
        }
        return reply;
    }
}

